package buildcraft.core.lib.client.sprite;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

public class SubSprite extends TextureAtlasSprite {
    private final TextureAtlasSprite icon;
    private float u, v;
    private final int w, h;
    private float uScale, vScale;
    private int iw, ih;

    public SubSprite(TextureAtlasSprite icon, int u, int v) {
        this(icon, u, v, 16, 16);
    }

    public SubSprite(TextureAtlasSprite icon, int u, int v, int w, int h) {
        super(icon.func_94215_i() + "_SubIcon");
        iw = icon.func_94211_a();
        ih = icon.func_94216_b();
        this.icon = icon;
        this.uScale = icon.func_94212_f() - icon.func_94209_e();
        this.vScale = icon.func_94210_h() - icon.func_94206_g();
        this.u = icon.func_94209_e() + (this.uScale * u / iw);
        this.v = icon.func_94206_g() + (this.vScale * v / ih);
        this.w = w;
        this.h = h;
    }

    @Override
    public int func_94211_a() {
        return w;
    }

    @Override
    public int func_94216_b() {
        return h;
    }

    @Override
    public float func_94209_e() {
        return u;
    }

    @Override
    public float func_94212_f() {
        return u + (uScale * w / iw);
    }

    @Override
    public float func_94214_a(double uu) {
        return u + (uScale * (float) uu / iw);
    }

    @Override
    public float func_94206_g() {
        return v;
    }

    @Override
    public float func_94210_h() {
        return v + (vScale * h / ih);
    }

    @Override
    public float func_94207_b(double vv) {
        return v + (vScale * (float) vv / ih);
    }

    @Override
    public String func_94215_i() {
        return icon.func_94215_i();
    }

    public static abstract class DelegateSprite extends TextureAtlasSprite {
        protected final TextureAtlasSprite delegate;

        protected DelegateSprite(TextureAtlasSprite delegate, String spriteName) {
            super(delegate.func_94215_i() + spriteName);
            this.delegate = delegate;
        }

        // @formatter:off
        @Override public int hashCode() {return delegate.hashCode();}
        @Override public void func_110971_a(int inX, int inY, int originInX, int originInY, boolean rotatedIn) {delegate.func_110971_a(inX, inY, originInX, originInY, rotatedIn);}
        @Override public void func_94217_a(TextureAtlasSprite atlasSpirit){delegate.func_94217_a(atlasSpirit);}
        @Override public int func_130010_a() {return delegate.func_130010_a();}
        @Override public int func_110967_i() {return delegate.func_110967_i();}
        @Override public int func_94211_a() {return delegate.func_94211_a();}
        @Override public boolean equals(Object obj) {return delegate.equals(obj);}
        @Override public int func_94216_b() {return delegate.func_94216_b();}
        @Override public float func_94209_e() {return delegate.func_94209_e();}
        @Override public float func_94212_f() {return delegate.func_94212_f();}
        @Override public float func_94214_a(double u) {return delegate.func_94214_a(u);}
        @Override public float func_94206_g() {return delegate.func_94206_g();}
        @Override public float func_94210_h() {return delegate.func_94210_h();}
        @Override public float func_94207_b(double v) {return delegate.func_94207_b(v);}
        @Override public String func_94215_i() {return delegate.func_94215_i();}
        @Override public void func_94219_l() {delegate.func_94219_l();}
        @Override public int[][] func_147965_a(int index) {return delegate.func_147965_a(index);}
        @Override public int func_110970_k() {return delegate.func_110970_k();}
        @Override public void func_110966_b(int newWidth) {delegate.func_110966_b(newWidth);}
        @Override public void func_110969_c(int newHeight) {delegate.func_110969_c(newHeight);}
        @Override public void func_180598_a(BufferedImage[] images, AnimationMetadataSection meta) throws IOException {delegate.func_180598_a(images, meta);}
        @Override public void func_147963_d(int level) {delegate.func_147963_d(level);}
        @Override public void func_130103_l() {delegate.func_130103_l();}
        @Override public boolean func_130098_m() {return delegate.func_130098_m();}
        @Override public void func_110968_a(List<int[][]> newFramesTextureData) {delegate.func_110968_a(newFramesTextureData);}
        @Override public String toString() {return delegate.toString();}
        @Override public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {return delegate.hasCustomLoader(manager, location);}
        @Override public boolean load(IResourceManager manager, ResourceLocation location) {return delegate.load(manager, location);}
        // @formatter:on
    }

    public static class FlippedU extends DelegateSprite {
        public FlippedU(TextureAtlasSprite delegate) {
            super(delegate, "_Flipped_U");
        }

        @Override
        public float func_94209_e() {
            return delegate.func_94212_f();
        }

        @Override
        public float func_94212_f() {
            return delegate.func_94209_e();
        }

        @Override
        public float func_94214_a(double u) {
            return delegate.func_94214_a(16 - u);
        }
    }

    public static class FlippedV extends DelegateSprite {
        public FlippedV(TextureAtlasSprite delegate) {
            super(delegate, "_Flipped_V");
        }

        @Override
        public float func_94206_g() {
            return delegate.func_94210_h();
        }

        @Override
        public float func_94210_h() {
            return delegate.func_94206_g();
        }

        @Override
        public float func_94207_b(double v) {
            return delegate.func_94207_b(16 - v);
        }
    }
}
