/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.commands;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;

public class RootCommand extends CommandBase implements IModCommand {
    public final String name;
    private final List<String> aliases = new ArrayList<>();
    private final SortedSet<SubCommand> children = new TreeSet<>(new Comparator<SubCommand>() {
        @Override
        public int compare(SubCommand o1, SubCommand o2) {
            return o1.compareTo(o2);
        }
    });

    public RootCommand(String name) {
        this.name = name;
    }

    public void addChildCommand(SubCommand child) {
        child.setParent(this);
        children.add(child);
    }

    public void addAlias(String alias) {
        aliases.add(alias);
    }

    @Override
    public SortedSet<SubCommand> getChildren() {
        return children;
    }

    @Override
    public String func_71517_b() {
        return name;
    }

    @Override
    public int func_82362_a() {
        return 0;
    }

    @Override
    public int getMinimumPermissionLevel() {
        return 0;
    }

    @Override
    public List<String> func_71514_a() {
        return aliases;
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!CommandHelpers.processStandardCommands(sender, this, args)) {
            CommandHelpers.throwWrongUsage(sender, this);
        }
    }

    @Override
    public String getFullCommandString() {
        return func_71517_b();
    }

    @Override
    public void printHelp(ICommandSender sender) {
        CommandHelpers.printHelp(sender, this);
    }
}
