/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.engines;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;

import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.utils.Utils;

public abstract class TileEngineWithInventory extends TileEngineBase implements IInventory, ISidedInventory {

    private final SimpleInventory inv;
    private final int[] defaultSlotArray;

    public TileEngineWithInventory(int invSize) {
        inv = new SimpleInventory(invSize, "Engine", 64);
        defaultSlotArray = Utils.createSlotArray(0, invSize);
    }

    /* IINVENTORY IMPLEMENTATION */
    @Override
    public int func_70302_i_() {
        return inv.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return inv.func_70301_a(slot);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        return inv.func_70298_a(slot, amount);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return inv.func_70304_b(slot);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        inv.func_70299_a(slot, itemstack);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return field_145850_b.func_175625_s(field_174879_c) == this;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        inv.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        inv.writeToNBT(data);
    }

    // ISidedInventory

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == orientation) {
            return new int[0];
        } else {
            return defaultSlotArray;
        }
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return side != orientation;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return side != orientation;
    }

    @Override
    public String getName() {
        return "Engine";
    }

    @Override
    public boolean hasCustomName() {
        return true;
    }

    @Override
    public IChatComponent getDisplayName() {
        return new ChatComponentText("Engine");
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}
}
