/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.fluids;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraftFluid;
import buildcraft.core.lib.fluids.FluidDefinition.BCFluid;
import buildcraft.core.lib.utils.IModelRegister;
import buildcraft.core.lib.utils.ModelHelper;

public class ItemBucketBuildcraft extends ItemBucket implements IModelRegister {
    private final BCFluid fluid;

    public ItemBucketBuildcraft(BlockBuildCraftFluid block, BCFluid fluid) {
        this(block, fluid, BCCreativeTab.get("main"));
    }

    public ItemBucketBuildcraft(Block block, BCFluid fluid, CreativeTabs creativeTab) {
        super(block);
        this.fluid = fluid;
        func_77642_a(Items.field_151133_ar);
        func_77637_a(creativeTab);
    }

    @Override
    public void registerModels() {
        ModelHelper.registerItemModel(this, 0, "forge:dynbucket", "");
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String unloc = StatCollector.func_74838_a(fluid.getUnlocalizedName());
        String s = "buildcraft.fluid.heat_" + fluid.getHeatValue();
        String heatString = StatCollector.func_74838_a(s);
        if (s.equals(heatString) || !fluid.isHeatable()) heatString = "";
        return unloc + " " + StatCollector.func_74838_a("item.bucket.name") + heatString;
    }
}
