/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.fluids;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.inventory.InvUtils;

public final class TankUtils {

    /** Deactivate constructor */
    private TankUtils() {}

    public static boolean handleRightClick(IFluidHandler tank, EnumFacing side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null || tank == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {

            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem(current);

            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);

                if (used > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }

            } else if (drain) {

                FluidStack available = tank.drain(side, Integer.MAX_VALUE, false);
                if (available != null) {
                    ItemStack filled = FluidContainerRegistry.fillFluidContainer(available, current);

                    liquid = FluidContainerRegistry.getFluidForFilledItem(filled);
                    if (liquid != null) {

                        if (current.field_77994_a > 1) {
                            if (!player.field_71071_by.func_70441_a(filled)) {
                                return false;
                            }
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                            player.field_71071_by.func_70296_d();
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                            player.field_71071_by.func_70296_d();
                        }

                        tank.drain(side, liquid.amount, true);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Block getFluidBlock(Fluid fluid, boolean moving) {
        if (fluid == FluidRegistry.WATER) {
            return moving ? Blocks.field_150358_i : Blocks.field_150355_j;
        }
        if (fluid == FluidRegistry.LAVA) {
            return moving ? Blocks.field_150356_k : Blocks.field_150353_l;
        }
        return fluid.getBlock();
    }

    public static void pushFluidToConsumers(IFluidTank tank, int flowCap, TileBuffer[] tileBuffer) {
        int amountToPush = flowCap;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            FluidStack fluidStack = tank.drain(amountToPush, false);
            if (fluidStack != null && fluidStack.amount > 0) {
                TileEntity tile = tileBuffer[side.ordinal()].getTile();
                if (tile instanceof IFluidHandler) {
                    int used = ((IFluidHandler) tile).fill(side.func_176734_d(), fluidStack, true);
                    if (used > 0) {
                        amountToPush -= used;
                        tank.drain(used, true);
                        if (amountToPush <= 0) {
                            return;
                        }
                    }
                }
            }
        }
    }
}
