/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.gui;

import java.io.IOException;
import java.util.ArrayList;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class GuiAdvancedInterface extends GuiBuildCraft {

    public ArrayList<AdvancedSlot> slots = new ArrayList<>();

    public GuiAdvancedInterface(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    public int getSlotIndexAtLocation(int i, int j) {
        int x = i - field_147003_i;
        int y = j - field_147009_r;

        for (int position = 0; position < slots.size(); ++position) {
            AdvancedSlot s = slots.get(position);

            if (s != null && x >= s.x && x <= s.x + 16 && y >= s.y && y <= s.y + 16) {
                return position;
            }
        }
        return -1;
    }

    public AdvancedSlot getSlotAtLocation(int i, int j) {
        int id = getSlotIndexAtLocation(i, j);

        if (id != -1) {
            return slots.get(id);
        } else {
            return null;
        }
    }

    private boolean isMouseOverSlot(AdvancedSlot slot, int mouseX, int mouseY) {
        int realMouseX = mouseX - this.field_147003_i;
        int realMouseY = mouseY - this.field_147009_r;
        return realMouseX >= slot.x - 1 && realMouseX < slot.x + 16 + 1 && realMouseY >= slot.y - 1 && realMouseY < slot.y + 16 + 1;
    }

    protected void drawSlotHighlight(AdvancedSlot slot, int mouseX, int mouseY) {
        if (this.isMouseOverSlot(slot, mouseX, mouseY) && slot.shouldDrawHighlight()) {
            GlStateManager.func_179135_a(true, true, true, false);
            this.func_73733_a(field_147003_i + slot.x, field_147009_r + slot.y, field_147003_i + slot.x + 16, field_147009_r + slot.y + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a(true, true, true, true);
        }
    }

    protected void drawBackgroundSlots(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glPushAttrib(GL11.GL_TRANSFORM_BIT);
        GlStateManager.func_179091_B();
        int i1 = 240;
        int k1 = 240;
        OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, i1 / 1.0F, k1 / 1.0F);

        if (slots != null) {
            for (AdvancedSlot slot : slots) {
                if (slot != null) {
                    slot.drawSprite(field_147003_i, field_147009_r);
                    drawSlotHighlight(slot, mouseX, mouseY);
                }
            }
        }
        GlStateManager.func_179131_c(1f, 1f, 1f, 1f);

        GlStateManager.func_179101_C();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void drawTooltipForSlotAt(int mouseX, int mouseY) {
        AdvancedSlot slot = getSlotAtLocation(mouseX, mouseY);

        if (slot != null) {
            slot.drawTooltip(this, mouseX, mouseY);
        }
    }

    public void drawTooltip(String caption, int mouseX, int mouseY) {
        if (caption.length() > 0) {
            int i2 = mouseX - field_147003_i;
            int k2 = mouseY - field_147009_r;
            func_146279_a(caption, i2, k2);
        }
    }

    public RenderItem getItemRenderer() {
        return field_146296_j;
    }

    @Override
    public void func_146285_a(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    public void drawStack(ItemStack item, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();

        if (item != null) {
            GlStateManager.func_179145_e();
            float prevZ = getItemRenderer().field_77023_b;
            getItemRenderer().field_77023_b = 200F;
            getItemRenderer().func_180450_b(item, x, y);
            getItemRenderer().func_180453_a(mc.field_71466_p, item, x, y, null);
            getItemRenderer().field_77023_b = prevZ;
            GlStateManager.func_179140_f();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);

        AdvancedSlot slot = getSlotAtLocation(mouseX, mouseY);

        if (slot != null && slot.isDefined()) {
            slotClicked(slot, mouseButton);
        }
    }

    public void resetNullSlots(int size) {
        slots.clear();

        for (int i = 0; i < size; ++i) {
            slots.add(null);
        }
    }

    // TODO: Use this for all children of this class
    protected void slotClicked(AdvancedSlot slot, int mouseButton) {

    }
}
