/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.gui;

import java.io.IOException;
import java.util.Collection;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

import net.minecraftforge.fluids.FluidStack;

import buildcraft.core.lib.client.render.FluidRenderer;
import buildcraft.core.lib.client.render.RenderUtils;
import buildcraft.core.lib.client.render.FluidRenderer.FluidType;
import buildcraft.core.lib.gui.slots.IPhantomSlot;
import buildcraft.core.lib.gui.tooltips.IToolTipProvider;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.gui.widgets.Widget;

public abstract class GuiBuildCraft extends GuiContainer {

    public static final ResourceLocation LEDGER_TEXTURE = new ResourceLocation("buildcraftcore:textures/gui/ledger.png");
    public final LedgerManager ledgerManager = new LedgerManager(this);
    public final TileEntity tile;
    public final BuildCraftContainer container;
    public ResourceLocation texture;

    public GuiBuildCraft(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container);
        this.container = container;

        this.texture = texture;

        if (inventory instanceof TileEntity) {
            tile = (TileEntity) inventory;
        } else {
            tile = null;
        }

        initLedgers(inventory);
    }

    public FontRenderer getFontRenderer() {
        return field_146289_q;
    }

    protected void initLedgers(IInventory inventory) {}

    // Protected/private methods made public
    public int xSize() {
        return field_146999_f;
    }

    public int ySize() {
        return field_147000_g;
    }

    @Override
    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public void func_175175_a(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        super.func_175175_a(xCoord, yCoord, textureSprite != null ? textureSprite : Minecraft.func_71410_x().func_147117_R().func_174944_f(), widthIn, heightIn);
    }

    /** Draws the screen and all the components in it. */
    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        int left = this.field_147003_i;
        int top = this.field_147009_r;

        GlStateManager.func_179097_i();
        GL11.glPushMatrix();
        GL11.glTranslatef(left, top, 0.0F);
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        RenderHelper.func_74518_a();

        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;

        if (playerInv.func_70445_o() == null) {
            drawToolTips(container.getWidgets(), mouseX - left, mouseY - top, left, top);
            drawToolTips(field_146292_n, mouseX, mouseY, 0, 0);
            drawToolTips(field_147002_h.field_75151_b, mouseX, mouseY, 0, 0);
        }

        GL11.glPopMatrix();
        GlStateManager.func_179126_j();
    }

    private void drawToolTips(Collection<?> objects, int mouseX, int mouseY, int offsetX, int offsetY) {
        for (Object obj : objects) {
            if (!(obj instanceof IToolTipProvider)) {
                continue;
            }
            IToolTipProvider provider = (IToolTipProvider) obj;
            if (!provider.isToolTipVisible()) {
                continue;
            }
            ToolTip tips = provider.getToolTip();
            if (tips == null) {
                continue;
            }
            boolean mouseOver = provider.isMouseOver(mouseX, mouseY);
            tips.onTick(mouseOver);
            if (mouseOver && tips.isReady()) {
                tips.refresh();
                drawToolTips(tips, mouseX + offsetX, mouseY + offsetY);
            }
        }
    }

    /** Draws a fluid into the gui. This will automatically cut and/or repeat the fluid sprite to ensure that it can
     * fill up any sized tank while keeping the sprite the correct size and scale. */
    public void drawFluid(FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }

        TextureAtlasSprite sprite = FluidRenderer.getFluidTexture(fluid.getFluid(), FluidType.STILL);

        field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtils.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int level = fluid.amount * height / maxCapacity;
        int fullLvl = (height - level) / 16;
        int lastLvl = (height - level) - fullLvl * 16;
        for (int i = 0; i < fullX; i++) {
            for (int j = 0; j < fullY; j++) {
                if (j >= fullLvl) {
                    drawCutIcon(sprite, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
                }
            }
        }
        for (int i = 0; i < fullX; i++) {
            drawCutIcon(sprite, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
        }
        for (int i = 0; i < fullY; i++) {
            if (i >= fullLvl) {
                drawCutIcon(sprite, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
            }
        }
        drawCutIcon(sprite, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
        GlStateManager.func_179131_c(1, 1, 1, 1);
    }

    // The magic is here
    private void drawCutIcon(TextureAtlasSprite icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.func_178181_a();
        WorldRenderer wr = tess.func_178180_c();
        wr.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181707_g);
        vertexUV(wr, x, y + height, field_73735_i, icon.func_94209_e(), icon.func_94207_b(height));
        vertexUV(wr, x + width, y + height, field_73735_i, icon.func_94214_a(width), icon.func_94207_b(height));
        vertexUV(wr, x + width, y + cut, field_73735_i, icon.func_94214_a(width), icon.func_94207_b(cut));
        vertexUV(wr, x, y + cut, field_73735_i, icon.func_94209_e(), icon.func_94207_b(cut));
        tess.func_78381_a();
    }

    private static void vertexUV(WorldRenderer wr, double x, double y, double z, double u, double v) {
        wr.func_181662_b(x, y, z).func_181673_a(u, v).func_181675_d();;
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        bindTexture(texture);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);

        int mX = mouseX - field_147003_i;
        int mY = mouseY - field_147009_r;

        drawWidgets(mX, mY);
    }

    protected void drawWidgets(int mX, int mY) {
        for (Widget widget : container.getWidgets()) {
            if (widget.hidden) {
                continue;
            }
            bindTexture(texture);
            widget.draw(this, field_147003_i, field_147009_r, mX, mY);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        drawLedgers(par1, par2);
    }

    protected void drawLedgers(int x, int y) {
        ledgerManager.drawLedgers(x, y);
    }

    public void drawCenteredString(String string, int xCenter, int yCenter, int textColor) {
        int x = xCenter - field_146289_q.func_78256_a(string) / 2;
        int y = yCenter - field_146289_q.field_78288_b / 2;
        field_146289_q.func_78276_b(string, x, y, textColor);
        // Reset the colour afterwards as drawString leaves it at the last colour drawn
        GlStateManager.func_179131_c(1, 1, 1, 1);
    }

    protected int getCenteredOffset(String string) {
        return getCenteredOffset(string, field_146999_f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - field_146289_q.func_78256_a(string)) / 2;
    }

    /** Returns if the passed mouse position is over the specified slot. */
    private boolean isMouseOverSlot(Slot slot, int mouseX, int mouseY) {
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        int realMouseX = mouseX - left;
        int realMouseY = mouseY - top;
        return realMouseX >= slot.field_75223_e - 1 && realMouseX < slot.field_75223_e + 16 + 1 && realMouseY >= slot.field_75221_f - 1
            && realMouseY < slot.field_75221_f + 16 + 1;
    }

    // / MOUSE CLICKS
    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int mX = mouseX - field_147003_i;
        int mY = mouseY - field_147009_r;

        for (Widget widget : container.getWidgets()) {
            if (widget.hidden) {
                continue;
            } else if (!widget.isMouseOver(mX, mY)) {
                continue;
            } else if (widget.handleMouseClick(mX, mY, mouseButton)) {
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);

        // / Handle ledger clicks
        ledgerManager.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long time) {
        int mX = mouseX - field_147003_i;
        int mY = mouseY - field_147009_r;
        for (Widget widget : container.getWidgets()) {
            if (widget.hidden) {
                continue;
            }
            widget.handleMouseMove(mX, mY, mouseButton, time);
        }

        Slot slot = getSlotAtPosition(mouseX, mouseY);
        if (mouseButton == 1 && slot instanceof IPhantomSlot) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, mouseButton, time);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);

        int mX = mouseX - field_147003_i;
        int mY = mouseY - field_147009_r;
        for (Widget widget : container.getWidgets()) {
            if (widget.hidden) {
                continue;
            }
            widget.handleMouseRelease(mX, mY, eventType);
        }
    }

    public Slot getSlotAtPosition(int x, int y) {
        for (int slotIndex = 0; slotIndex < this.field_147002_h.field_75151_b.size(); ++slotIndex) {
            Slot slot = (Slot) this.field_147002_h.field_75151_b.get(slotIndex);
            if (isMouseOverSlot(slot, x, y)) {
                return slot;
            }
        }
        return null;
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        if (toolTips.size() > 0) {
            int left = this.field_147003_i;
            int top = this.field_147009_r;
            int length = 0;
            int x;
            int y;

            for (ToolTipLine tip : toolTips) {
                y = this.field_146289_q.func_78256_a(tip.text);

                if (y > length) {
                    length = y;
                }
            }

            x = mouseX - left + 12;
            y = mouseY - top - 12;
            int var14 = 8;

            if (toolTips.size() > 1) {
                var14 += 2 + (toolTips.size() - 1) * 10;
            }

            this.field_73735_i = 300.0F;
            field_146296_j.field_77023_b = 300.0F;
            int var15 = -267386864;
            this.func_73733_a(x - 3, y - 4, x + length + 3, y - 3, var15, var15);
            this.func_73733_a(x - 3, y + var14 + 3, x + length + 3, y + var14 + 4, var15, var15);
            this.func_73733_a(x - 3, y - 3, x + length + 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x + length + 3, y - 3, x + length + 4, y + var14 + 3, var15, var15);
            int var16 = 1347420415;
            int var17 = (var16 & 16711422) >> 1 | var16 & -16777216;
            this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x + length + 2, y - 3 + 1, x + length + 3, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x - 3, y - 3, x + length + 3, y - 3 + 1, var16, var16);
            this.func_73733_a(x - 3, y + var14 + 2, x + length + 3, y + var14 + 3, var17, var17);

            for (ToolTipLine tip : toolTips) {
                String line = tip.text;

                if (tip.color == -1) {
                    line = "\u00a77" + line;
                } else {
                    line = "\u00a7" + Integer.toHexString(tip.color) + line;
                }

                this.field_146289_q.func_175063_a(line, x, y, -1);

                y += 10 + tip.getSpacing();
            }

            this.field_73735_i = 0.0F;
            field_146296_j.field_77023_b = 0.0F;
        }
    }

    public BuildCraftContainer getContainer() {
        return container;
    }
}
