/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.gui.buttons;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.core.lib.gui.tooltips.IToolTipProvider;
import buildcraft.core.lib.gui.tooltips.ToolTip;

@SideOnly(Side.CLIENT)
public class GuiBetterButton extends GuiButton implements IToolTipProvider {
    protected final IButtonTextureSet texture;
    private ToolTip toolTip;

    public GuiBetterButton(int id, int x, int y, String label) {
        this(id, x, y, 200, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    public GuiBetterButton(int id, int x, int y, int width, String label) {
        this(id, x, y, width, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    public GuiBetterButton(int id, int x, int y, int width, IButtonTextureSet texture, String label) {
        super(id, x, y, width, texture.getHeight(), label);
        this.texture = texture;
    }

    public int getWidth() {
        return field_146120_f;
    }

    public int getHeight() {
        return texture.getHeight();
    }

    public int getTextColor(boolean mouseOver) {
        if (!field_146124_l) {
            return 0xffa0a0a0;
        } else if (mouseOver) {
            return 0xffffa0;
        } else {
            return 0xe0e0e0;
        }
    }

    public boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= field_146128_h && mouseY >= field_146129_i && mouseX < field_146128_h + field_146120_f && mouseY < field_146129_i + getHeight();
    }

    protected void bindButtonTextures(Minecraft minecraft) {
        minecraft.field_71446_o.func_110577_a(texture.getTexture());
    }

    @Override
    public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!field_146125_m) {
            return;
        }

        FontRenderer fontrenderer = minecraft.field_71466_p;
        bindButtonTextures(minecraft);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        int xOffset = texture.getX();
        int yOffset = texture.getY();
        int h = texture.getHeight();
        int w = texture.getWidth();
        boolean mouseOver = isMouseOverButton(mouseX, mouseY);
        int hoverState = func_146114_a(mouseOver);
        func_73729_b(field_146128_h, field_146129_i, xOffset, yOffset + hoverState * h, field_146120_f / 2, h);
        func_73729_b(field_146128_h + field_146120_f / 2, field_146129_i, xOffset + w - field_146120_f / 2, yOffset + hoverState * h, field_146120_f / 2, h);
        func_146119_b(minecraft, mouseX, mouseY);
        func_73732_a(fontrenderer, field_146126_j, field_146128_h + field_146120_f / 2, field_146129_i + (h - 8) / 2, getTextColor(mouseOver));
    }

    @Override
    public ToolTip getToolTip() {
        return toolTip;
    }

    public GuiBetterButton setToolTip(ToolTip tips) {
        this.toolTip = tips;
        return this;
    }

    @Override
    public boolean isToolTipVisible() {
        return field_146125_m;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return isMouseOverButton(mouseX, mouseY);
    }
}
