/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.gui.buttons;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.core.lib.gui.tooltips.ToolTip;

@SideOnly(Side.CLIENT)
public class GuiMultiButton extends GuiBetterButton {

    private final MultiButtonController<?> control;

    public GuiMultiButton(int id, int x, int y, int width, MultiButtonController<?> control) {
        super(id, x, y, width, StandardButtonTextureSets.LARGE_BUTTON, "");
        this.control = control;
    }

    @Override
    public int getHeight() {
        return texture.getHeight();
    }

    @Override
    public void func_146112_a(Minecraft minecraft, int x, int y) {
        if (!field_146125_m) {
            return;
        }

        FontRenderer fontrenderer = minecraft.field_71466_p;
        bindButtonTextures(minecraft);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        IMultiButtonState state = control.getButtonState();
        IButtonTextureSet tex = state.getTextureSet();
        int xOffset = tex.getX();
        int yOffset = tex.getY();
        int h = tex.getHeight();
        int w = tex.getWidth();
        boolean flag = x >= field_146128_h && y >= field_146129_i && x < field_146128_h + field_146120_f && y < field_146129_i + h;
        int hoverState = func_146114_a(flag);
        func_73729_b(field_146128_h, field_146129_i, xOffset, yOffset + hoverState * h, field_146120_f / 2, h);
        func_73729_b(field_146128_h + field_146120_f / 2, field_146129_i, xOffset + w - field_146120_f / 2, yOffset + hoverState * h, field_146120_f / 2, h);
        func_146119_b(minecraft, x, y);
        field_146126_j = state.getLabel();
        if (!"".equals(field_146126_j)) {
            if (!field_146124_l) {
                func_73732_a(fontrenderer, field_146126_j, field_146128_h + field_146120_f / 2, field_146129_i + (h - 8) / 2, 0xffa0a0a0);
            } else if (flag) {
                func_73732_a(fontrenderer, field_146126_j, field_146128_h + field_146120_f / 2, field_146129_i + (h - 8) / 2, 0xffffa0);
            } else {
                func_73732_a(fontrenderer, field_146126_j, field_146128_h + field_146120_f / 2, field_146129_i + (h - 8) / 2, 0xe0e0e0);
            }
        }
    }

    @Override
    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        boolean pressed = super.func_146116_c(par1Minecraft, par2, par3);
        if (pressed && field_146124_l) {
            control.incrementState();
        }
        return pressed;
    }

    public MultiButtonController<?> getController() {
        return control;
    }

    @Override
    public ToolTip getToolTip() {
        ToolTip tip = this.control.getButtonState().getToolTip();
        if (tip != null) {
            return tip;
        }
        return super.getToolTip();
    }
}
