/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.gui.slots;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

import buildcraft.core.lib.gui.tooltips.IToolTipProvider;
import buildcraft.core.lib.gui.tooltips.ToolTip;

public class SlotBase extends Slot implements IToolTipProvider {

    private ToolTip toolTips;

    public SlotBase(IInventory iinventory, int slotIndex, int posX, int posY) {
        super(iinventory, slotIndex, posX, posY);
    }

    public boolean canShift() {
        return true;
    }

    /** @return the toolTips */
    @Override
    public ToolTip getToolTip() {
        return toolTips;
    }

    /** @param toolTips the tooltips to set */
    public void setToolTips(ToolTip toolTips) {
        this.toolTips = toolTips;
    }

    @Override
    public boolean isToolTipVisible() {
        return func_75211_c() == null;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= field_75223_e && mouseX <= field_75223_e + 16 && mouseY >= field_75221_f && mouseY <= field_75221_f + 16;
    }
}
