/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;

/** Allows you to deal with multiple inventories through a single interface. */
public final class InventoryConcatenator implements IInventory {

    private final List<Integer> slotMap = new ArrayList<>();
    private final List<IInventory> invMap = new ArrayList<>();

    private InventoryConcatenator() {}

    public static InventoryConcatenator make() {
        return new InventoryConcatenator();
    }

    public InventoryConcatenator add(IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); slot++) {
            slotMap.add(slot);
            invMap.add(inv);
        }
        return this;
    }

    @Override
    public int func_70302_i_() {
        return slotMap.size();
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return invMap.get(slot).func_70301_a(slotMap.get(slot));
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        return invMap.get(slot).func_70298_a(slotMap.get(slot), amount);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return invMap.get(slot).func_70304_b(slotMap.get(slot));
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        invMap.get(slot).func_70299_a(slotMap.get(slot), stack);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return invMap.get(slot).func_94041_b(slotMap.get(slot), stack);
    }

    @Override
    public void func_70296_d() {
        for (IInventory inv : invMap) {
            inv.func_70296_d();
        }
    }

    @Override
    public String func_70005_c_() {
        return null;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public IChatComponent func_145748_c_() {
        return null;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {}

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {}
}
