/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;

/** Creates a deep copy of an existing IInventory.
 *
 * Useful for performing inventory manipulations and then examining the results without affecting the original
 * inventory. */
public class InventoryCopy implements IInventory {

    private IInventory original;
    private ItemStack[] contents;

    public InventoryCopy(IInventory orignal) {
        this.original = orignal;
        contents = new ItemStack[orignal.func_70302_i_()];
        for (int i = 0; i < contents.length; i++) {
            ItemStack stack = orignal.func_70301_a(i);
            if (stack != null) {
                contents[i] = stack.func_77946_l();
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return contents.length;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return contents[i];
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        if (contents[i] != null) {
            if (contents[i].field_77994_a <= j) {
                ItemStack itemstack = contents[i];
                contents[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = contents[i].func_77979_a(j);
            if (contents[i].field_77994_a <= 0) {
                contents[i] = null;
            }
            return itemstack1;
        } else {
            return null;
        }
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        contents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > func_70297_j_()) {
            itemstack.field_77994_a = func_70297_j_();
        }
    }

    @Override
    public int func_70297_j_() {
        return original.func_70297_j_();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return original.func_70304_b(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return original.func_94041_b(slot, stack);
    }

    public ItemStack[] getItemStacks() {
        return contents;
    }

    @Override
    public void func_70296_d() {

    }

    @Override
    public String func_70005_c_() {
        return original.func_70005_c_();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public IChatComponent func_145748_c_() {
        return original.func_145748_c_();
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {}

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {}
}
