/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import java.util.Iterator;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

import buildcraft.api.core.IInvSlot;

class InventoryIteratorSimple implements Iterable<IInvSlot> {

    private final IInventory inv;

    InventoryIteratorSimple(IInventory inv) {
        this.inv = InvUtils.getInventory(inv);
    }

    @Override
    public Iterator<IInvSlot> iterator() {
        return new Iterator<IInvSlot>() {
            int slot = 0;

            @Override
            public boolean hasNext() {
                return slot < inv.func_70302_i_();
            }

            @Override
            public IInvSlot next() {
                return new InvSlot(slot++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        };
    }

    private class InvSlot implements IInvSlot {

        private int slot;

        public InvSlot(int slot) {
            this.slot = slot;
        }

        @Override
        public ItemStack getStackInSlot() {
            return inv.func_70301_a(slot);
        }

        @Override
        public void setStackInSlot(ItemStack stack) {
            inv.func_70299_a(slot, stack);
        }

        @Override
        public boolean canPutStackInSlot(ItemStack stack) {
            return inv.func_94041_b(slot, stack);
        }

        @Override
        public boolean canTakeStackFromSlot(ItemStack stack) {
            return true;
        }

        @Override
        public boolean isItemValidForSlot(ItemStack stack) {
            return inv.func_94041_b(slot, stack);
        }

        @Override
        public ItemStack decreaseStackInSlot(int amount) {
            return inv.func_70298_a(slot, amount);
        }

        @Override
        public int getIndex() {
            return slot;
        }
    }
}
