/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;

/** Wrapper class used to specify part of an existing inventory to be treated as a complete inventory. Used primarily to
 * map a side of an ISidedInventory, but it is also helpful for complex inventories such as the Tunnel Bore. */
public class InventoryMapper implements IInventory {

    private final IInventory inv;
    private final int start;
    private final int size;
    private int stackSizeLimit = -1;
    private boolean checkItems = true;

    /** Creates a new InventoryMapper
     *
     * @param inv The backing inventory
     * @param start The starting index
     * @param size The size of the new inventory, take care not to exceed the end of the backing inventory */
    public InventoryMapper(IInventory inv, int start, int size) {
        this(inv, start, size, true);
    }

    public InventoryMapper(IInventory inv, int start, int size, boolean checkItems) {
        this.inv = inv;
        this.start = start;
        this.size = size;
        this.checkItems = checkItems;
    }

    public IInventory getBaseInventory() {
        return inv;
    }

    @Override
    public int func_70302_i_() {
        return size;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return inv.func_70301_a(start + slot);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        return inv.func_70298_a(start + slot, amount);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        inv.func_70299_a(start + slot, itemstack);
    }

    @Override
    public String func_70005_c_() {
        return inv.func_70005_c_();
    }

    public void setStackSizeLimit(int limit) {
        stackSizeLimit = limit;
    }

    @Override
    public int func_70297_j_() {
        return stackSizeLimit > 0 ? stackSizeLimit : inv.func_70297_j_();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return inv.func_70300_a(entityplayer);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        inv.func_174889_b(player);
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        inv.func_174886_c(player);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return inv.func_70304_b(start + slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (checkItems) {
            return inv.func_94041_b(start + slot, stack);
        }
        return true;
    }

    @Override
    public boolean func_145818_k_() {
        return inv.func_145818_k_();
    }

    @Override
    public void func_70296_d() {
        inv.func_70296_d();
    }

    @Override
    public IChatComponent func_145748_c_() {
        return null;
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {}

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {}
}
