/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;

public abstract class InventoryWrapper implements ISidedInventory {

    IInventory inventory;

    public InventoryWrapper(IInventory inventory) {
        this.inventory = inventory;
    }

    /* DIRECT MAPPING */
    @Override
    public int func_70302_i_() {
        return inventory.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int slotIndex) {
        return inventory.func_70301_a(slotIndex);
    }

    @Override
    public ItemStack func_70298_a(int slotIndex, int amount) {
        return inventory.func_70298_a(slotIndex, amount);
    }

    @Override
    public ItemStack func_70304_b(int slotIndex) {
        return inventory.func_70304_b(slotIndex);
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        inventory.func_70299_a(slotIndex, itemstack);
    }

    @Override
    public int func_70297_j_() {
        return inventory.func_70297_j_();
    }

    @Override
    public void func_70296_d() {
        inventory.func_70296_d();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return inventory.func_70300_a(entityplayer);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        inventory.func_174889_b(player);
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        inventory.func_174886_c(player);
    }

    @Override
    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return inventory.func_94041_b(slotIndex, itemstack);
    }

    @Override
    public boolean func_145818_k_() {
        return inventory.func_145818_k_();
    }

    @Override
    public int func_174887_a_(int id) {
        return inventory.func_174887_a_(id);
    }

    @Override
    public void func_174885_b(int id, int value) {
        inventory.func_174885_b(id, value);
    }

    @Override
    public int func_174890_g() {
        return inventory.func_174890_g();
    }

    @Override
    public void func_174888_l() {
        inventory.func_174888_l();
    }

    @Override
    public String func_70005_c_() {
        return inventory.func_70005_c_();
    }

    @Override
    public IChatComponent func_145748_c_() {
        return inventory.func_145748_c_();
    }

    /* STATIC HELPER */
    public static ISidedInventory getWrappedInventory(Object inventory) {
        if (inventory instanceof ISidedInventory) {
            return (ISidedInventory) inventory;
        } else if (inventory instanceof IInventory) {
            return new InventoryWrapperSimple(InvUtils.getInventory((IInventory) inventory));
        } else {
            return null;
        }
    }
}
