/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

import buildcraft.core.lib.utils.Utils;

public class InventoryWrapperSimple extends InventoryWrapper {

    private final int[] slots;

    public InventoryWrapperSimple(IInventory inventory) {
        super(inventory);
        slots = Utils.createSlotArray(0, inventory.func_70302_i_());
    }

    @Override
    public int[] func_180463_a(EnumFacing var1) {
        return slots;
    }

    @Override
    public boolean func_180462_a(int slotIndex, ItemStack itemstack, EnumFacing side) {
        return func_94041_b(slotIndex, itemstack);
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, EnumFacing side) {
        return true;
    }
}
