/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import java.util.List;

import com.google.common.collect.Lists;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

import net.minecraftforge.common.util.Constants;

import buildcraft.api.core.INBTStoreable;

public class SimpleInventory implements IInventory, INBTStoreable {

    private final ItemStack[] contents;
    private final String name;
    private final int stackLimit;
    /** Used to update tile entities about whenever something changed so that it must save */
    private final List<TileEntity> listener = Lists.newLinkedList();
    /** Used to update a tile entities about exactly WHAT changed, when it changed */
    private final List<IInventoryListener> listeners = Lists.newLinkedList();

    public SimpleInventory(int size, String invName, int invStackLimit) {
        contents = new ItemStack[size];
        name = invName;
        stackLimit = invStackLimit;
    }

    @Override
    public int func_70302_i_() {
        return contents.length;
    }

    @Override
    public ItemStack func_70301_a(int slotId) {
        return contents[slotId];
    }

    @Override
    public ItemStack func_70298_a(int slotId, int count) {
        if (slotId < contents.length && contents[slotId] != null) {
            if (contents[slotId].field_77994_a > count) {
                ItemStack before = contents[slotId];
                if (before != null) {
                    before = before.func_77946_l();
                }
                ItemStack result = contents[slotId].func_77979_a(count);
                updateListeners(slotId, before, contents[slotId]);
                func_70296_d();
                return result;
            }
            if (contents[slotId].field_77994_a < count) {
                return null;
            }
            ItemStack stack = contents[slotId];
            func_70299_a(slotId, null);
            return stack;
        }
        return null;
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemstack) {
        if (slotId >= contents.length) {
            return;
        }
        ItemStack before = contents[slotId];
        if (before != null) {
            before = before.func_77946_l();
        }
        contents[slotId] = itemstack;

        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        updateListeners(slotId, before, itemstack);
        func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return stackLimit;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("items")) {
            // this is to support legacy item load, the new format should be
            // "Items"
            readFromNBT(data, "items");
        } else {
            readFromNBT(data, "Items");
        }
    }

    public void readFromNBT(NBTTagCompound data, String tag) {
        NBTTagList nbttaglist = data.func_150295_c(tag, Constants.NBT.TAG_COMPOUND);

        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound slot = nbttaglist.func_150305_b(j);
            int index;
            if (slot.func_74764_b("index")) {
                index = slot.func_74762_e("index");
            } else {
                index = slot.func_74771_c("Slot");
            }
            if (index >= 0 && index < contents.length) {
                func_70299_a(index, ItemStack.func_77949_a(slot));
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        writeToNBT(data, "Items");
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagList slots = new NBTTagList();
        for (byte index = 0; index < contents.length; ++index) {
            if (contents[index] != null && contents[index].field_77994_a > 0) {
                NBTTagCompound slot = new NBTTagCompound();
                slots.func_74742_a(slot);
                slot.func_74774_a("Slot", index);
                contents[index].func_77955_b(slot);
            }
        }
        data.func_74782_a(tag, slots);
    }

    public void addListener(TileEntity listner) {
        listener.add(listner);
    }

    @Override
    public ItemStack func_70304_b(int slotId) {
        if (this.contents[slotId] == null) {
            return null;
        }

        ItemStack stackToTake = this.contents[slotId];
        func_70299_a(slotId, null);
        return stackToTake;
    }

    public ItemStack[] getItemStacks() {
        return contents;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public void func_70296_d() {
        for (TileEntity handler : listener) {
            handler.func_70296_d();
        }
    }

    @Override
    public String func_70005_c_() {
        return name;
    }

    @Override
    public IChatComponent func_145748_c_() {
        return new ChatComponentText(name);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {}

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {}

    /** Add a listener to receive changes to the inventory */
    public void addInvListener(IInventoryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("You cannot add a null listener!", new Throwable("Change this!"));
        }
        listeners.add(listener);
    }

    public void updateListeners(int slot, ItemStack before, ItemStack after) {
        for (IInventoryListener listener : listeners) {
            listener.onChange(slot, before, after);
        }
    }
}
