/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import buildcraft.api.core.IStackFilter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

import java.util.ArrayList;
import java.util.List;

public class TransactorItemHandler extends Transactor {

    protected IItemHandler handler;

    public TransactorItemHandler(IItemHandler handler) {
        this.handler = handler;
    }

    @Override
    public int inject(ItemStack stack, boolean doAdd) {
        List<Integer> filledSlots = new ArrayList<>(handler.getSlots());
        List<Integer> emptySlots = new ArrayList<>(handler.getSlots());
        for (int i = 0; i < handler.getSlots(); i++) {
            ItemStack simulated = handler.insertItem(i, stack, true);
            if (simulated == null || simulated.field_77994_a < stack.field_77994_a) {
                if (handler.getStackInSlot(i) == null) {
                    emptySlots.add(i);
                } else {
                    filledSlots.add(i);
                }
            }
        }

        int injected = 0;
        injected = tryPut(stack, filledSlots, injected, doAdd);
        injected = tryPut(stack, emptySlots, injected, doAdd);
        return injected;
    }

    private int tryPut(ItemStack stack, List<Integer> slots, int injected, boolean doAdd) {
        int realInjected = injected;
        ItemStack toInsert = null;

        if (realInjected >= stack.field_77994_a) {
            return realInjected;
        }

        for (int i : slots) {
            if (toInsert == null) {
                toInsert = stack.func_77946_l();
                toInsert.field_77994_a = stack.field_77994_a - realInjected;
            }
            int oldInjected = realInjected;
            ItemStack insertedStack = handler.insertItem(i, toInsert, !doAdd);
            if (insertedStack == null) {
                realInjected += stack.field_77994_a;
            } else {
                realInjected += stack.field_77994_a - insertedStack.field_77994_a;
            }
            if (realInjected >= stack.field_77994_a) {
                return realInjected;
            } else if (oldInjected != realInjected) {
                toInsert = null;
            }
        }

        return realInjected;
    }

    @Override
    public ItemStack remove(IStackFilter filter, boolean doRemove) {
        for (int i = 0; i < handler.getSlots(); i++) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack != null && filter.matches(stack)) {
                return handler.extractItem(i, 1, !doRemove);
            }
        }
        return null;
    }
}
