/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.inventory;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.IStackFilter;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

import java.util.ArrayList;
import java.util.List;

public class TransactorSimple extends Transactor {
    protected IInventory inventory;
    protected EnumFacing orientation;

    public TransactorSimple(IInventory inventory, EnumFacing orientation) {
        this.inventory = inventory;
        this.orientation = orientation;
    }

    @Override
    public int inject(ItemStack stack, boolean doAdd) {
        List<IInvSlot> filledSlots = new ArrayList<>(inventory.func_70302_i_());
        List<IInvSlot> emptySlots = new ArrayList<>(inventory.func_70302_i_());
        for (IInvSlot slot : InventoryIterator.getIterable(inventory, orientation)) {
            if (slot.canPutStackInSlot(stack)) {
                if (slot.getStackInSlot() == null) {
                    emptySlots.add(slot);
                } else {
                    filledSlots.add(slot);
                }
            }
        }

        int injected = 0;
        injected = tryPut(stack, filledSlots, injected, doAdd);
        injected = tryPut(stack, emptySlots, injected, doAdd);

        if (injected > 0 && doAdd) {
            inventory.func_70296_d();
        }
        return injected;
    }

    private int tryPut(ItemStack stack, List<IInvSlot> slots, int injected, boolean doAdd) {
        int realInjected = injected;

        if (realInjected >= stack.field_77994_a) {
            return realInjected;
        }

        for (IInvSlot slot : slots) {
            ItemStack stackInSlot = slot.getStackInSlot();
            if (stackInSlot == null || StackHelper.canStacksMerge(stackInSlot, stack)) {
                int used = addToSlot(slot, stack, realInjected, doAdd);
                if (used > 0) {
                    realInjected += used;
                    if (realInjected >= stack.field_77994_a) {
                        return realInjected;
                    }
                }
            }
        }

        return realInjected;
    }

    /** @param slot
     * @param stack
     * @param injected Amount not to move?
     * @param doAdd
     * @return Return the number of items moved. */
    protected int addToSlot(IInvSlot slot, ItemStack stack, int injected, boolean doAdd) {
        int available = stack.field_77994_a - injected;
        int max = Math.min(stack.func_77976_d(), inventory.func_70297_j_());

        ItemStack stackInSlot = slot.getStackInSlot();
        if (stackInSlot == null) {
            int wanted = Math.min(available, max);
            if (doAdd) {
                stackInSlot = stack.func_77946_l();
                stackInSlot.field_77994_a = wanted;
                slot.setStackInSlot(stackInSlot);
            }
            return wanted;
        }

        if (!StackHelper.canStacksMerge(stack, stackInSlot)) {
            return 0;
        }

        int wanted = max - stackInSlot.field_77994_a;
        if (wanted <= 0) {
            return 0;
        }

        if (wanted > available) {
            wanted = available;
        }

        if (doAdd) {
            stackInSlot.field_77994_a += wanted;
            slot.setStackInSlot(stackInSlot);
        }
        return wanted;
    }

    @Override
    public ItemStack remove(IStackFilter filter, boolean doRemove) {
        for (IInvSlot slot : InventoryIterator.getIterable(inventory, orientation)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack != null && slot.canTakeStackFromSlot(stack) && filter.matches(stack)) {
                if (doRemove) {
                    return slot.decreaseStackInSlot(1);
                } else {
                    ItemStack output = stack.func_77946_l();
                    output.field_77994_a = 1;
                    return output;
                }
            }
        }
        return null;
    }
}

