/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import buildcraft.api.core.ISerializable;

import io.netty.buffer.ByteBuf;

public class PacketTileUpdate extends PacketUpdate {
    public BlockPos pos;

    public PacketTileUpdate() {
        super();
    }

    public PacketTileUpdate(TileEntity tile, ISerializable ser) {
        super(ser);
        tempWorld = tile.func_145831_w();
        dimensionId = tile.func_145831_w().field_73011_w.func_177502_q();
        pos = tile.func_174877_v();
    }

    @Override
    public void writeIdentificationData(ByteBuf data) {
        data.writeInt(pos.func_177958_n());
        data.writeInt(pos.func_177956_o());
        data.writeInt(pos.func_177952_p());
    }

    @Override
    public void readIdentificationData(ByteBuf data) {
        pos = new BlockPos(data.readInt(), data.readInt(), data.readInt());
    }

    public boolean targetExists(World world) {
        return world.func_175667_e(pos);
    }

    public TileEntity getTarget(World world) {
        return world.func_175625_s(pos);
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (!targetExists(world)) {
            return;
        }

        TileEntity tile = getTarget(world);

        if (!(tile instanceof ISerializable)) {
            return;
        }

        ISerializable ser = (ISerializable) tile;
        ser.readData(payloadData);
    }
}
