/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.network.command;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

import io.netty.buffer.ByteBuf;

public class CommandTargetEntity extends CommandTarget {
    @Override
    public Class<?> getHandledClass() {
        return Entity.class;
    }

    @Override
    public void write(ByteBuf data, Object target) {
        Entity entity = (Entity) target;
        data.writeInt(entity.func_145782_y());
    }

    @Override
    public ICommandReceiver handle(EntityPlayer player, ByteBuf data, World world) {
        int id = data.readInt();
        Entity entity = world.func_73045_a(id);
        if (entity != null && entity instanceof ICommandReceiver) {
            return (ICommandReceiver) entity;
        }
        return null;
    }

    @Override
    public World getWorld(Object target) {
        return ((Entity) target).field_70170_p;
    }
}
