package buildcraft.core.lib.utils;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;

import buildcraft.BuildCraftCore;
import buildcraft.core.proxy.CoreProxy;

public class BlockMiner {
    protected final World world;
    protected final TileEntity owner;
    protected final BlockPos pos;

    private boolean hasMined, hasFailed;
    private int energyRequired, energyAccepted;

    public BlockMiner(World world, TileEntity owner, BlockPos pos) {
        this.world = world;
        this.owner = owner;
        this.pos = pos;
    }

    public boolean hasMined() {
        return hasMined;
    }

    public boolean hasFailed() {
        return hasFailed;
    }

    public void mineStack(ItemStack stack) {
        // First, try to add to a nearby chest
        stack.field_77994_a -= Utils.addToRandomInventoryAround(owner.func_145831_w(), owner.func_174877_v(), stack);

        // Second, try to add to adjacent pipes
        if (stack.field_77994_a > 0) {
            stack.field_77994_a -= Utils.addToRandomInjectableAround(owner.func_145831_w(), owner.func_174877_v(), null, stack);
        }

        // Lastly, throw the object away
        if (stack.field_77994_a > 0) {
            float f = world.field_73012_v.nextFloat() * 0.8F + 0.1F;
            float f1 = world.field_73012_v.nextFloat() * 0.8F + 0.1F;
            float f2 = world.field_73012_v.nextFloat() * 0.8F + 0.1F;

            EntityItem entityitem = new EntityItem(owner.func_145831_w(), owner.func_174877_v().func_177958_n() + f, owner.func_174877_v().func_177956_o() + f1 + 0.5F, owner.func_174877_v()
                    .func_177952_p() + f2, stack);

            entityitem.lifespan = BuildCraftCore.itemLifespan * 20;
            entityitem.func_174869_p();

            float f3 = 0.05F;
            entityitem.field_70159_w = (float) world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float) world.field_73012_v.nextGaussian() * f3 + 1.0F;
            entityitem.field_70179_y = (float) world.field_73012_v.nextGaussian() * f3;
            owner.func_145831_w().func_72838_d(entityitem);
        }
    }

    public void invalidate() {
        world.func_175715_c(pos.hashCode(), pos, -1);
    }

    public int acceptEnergy(int offeredAmount) {
        if (BlockUtils.isUnbreakableBlock(world, pos)) {
            hasFailed = true;
            return 0;
        }

        energyRequired = BlockUtils.computeBlockBreakEnergy(world, pos);

        int usedAmount = MathUtils.clamp(offeredAmount, 0, Math.max(0, energyRequired - energyAccepted));
        energyAccepted += usedAmount;

        if (energyAccepted >= energyRequired) {
            world.func_175715_c(pos.hashCode(), pos, -1);

            IBlockState state = world.func_180495_p(pos);

            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, state, CoreProxy.proxy.getBuildCraftPlayer((WorldServer) world)
                    .get());
            MinecraftForge.EVENT_BUS.post(breakEvent);

            if (!breakEvent.isCanceled()) {
                List<ItemStack> stacks = BlockUtils.getItemStackFromBlock((WorldServer) world, pos);

                if (stacks != null) {
                    for (ItemStack s : stacks) {
                        if (s != null) {
                            mineStack(s);
                        }
                    }
                }

                world.func_180498_a(null, 2001, pos, Block.func_176210_f(state));

                world.func_175698_g(pos);
                hasMined = true;
            } else {
                hasFailed = true;
            }
        } else {
            world.func_175715_c(pos.hashCode(), pos, MathUtils.clamp((int) Math.floor(energyAccepted * 10 / energyRequired), 0, 9));
        }
        return usedAmount;
    }
}
