/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.utils;

import java.util.Iterator;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import buildcraft.core.Box;

public class BlockScanner implements Iterable<BlockPos> {

    Box box = new Box();
    World world;

    BlockPos pos;
    int iterationsPerCycle;
    int blocksDone = 0;

    class BlockIt implements Iterator<BlockPos> {

        int it = 0;

        @Override
        public boolean hasNext() {
            return pos.func_177952_p() <= box.max().func_177952_p() && it <= iterationsPerCycle;
        }

        @Override
        public BlockPos next() {
            BlockPos index = new BlockPos(pos);
            it++;
            blocksDone++;

            if (pos.func_177958_n() < box.max().func_177958_n()) {
                pos = pos.func_177974_f();
            } else {
                pos = new BlockPos(box.min().func_177958_n(), pos.func_177956_o(), pos.func_177952_p());

                if (pos.func_177956_o() < box.max().func_177956_o()) {
                    pos = pos.func_177984_a();
                } else {
                    pos = new BlockPos(pos.func_177958_n(), box.min().func_177956_o(), pos.func_177952_p() + 1);
                }
            }

            return index;
        }

        @Override
        public void remove() {

        }
    }

    public BlockScanner(Box box, World world, int iterationsPreCycle) {
        this.box = box;
        this.world = world;
        this.iterationsPerCycle = iterationsPreCycle;
        pos = box.min();
    }

    public BlockScanner() {}

    @Override
    public Iterator<BlockPos> iterator() {
        return new BlockIt();
    }

    public int totalBlocks() {
        return box.size().func_177958_n() * box.size().func_177956_o() * box.size().func_177952_p();
    }

    public int blocksLeft() {
        return totalBlocks() - blocksDone;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("pos", NBTUtils.writeBlockPos(pos));
        nbt.func_74768_a("blocksDone", blocksDone);
        nbt.func_74768_a("iterationsPerCycle", iterationsPerCycle);
        NBTTagCompound boxNBT = new NBTTagCompound();
        box.writeToNBT(boxNBT);
        nbt.func_74782_a("box", boxNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        pos = NBTUtils.readBlockPos(nbt.func_74781_a("pos"));
        blocksDone = nbt.func_74762_e("blocksDone");
        iterationsPerCycle = nbt.func_74762_e("iterationsPerCycle");
        box.initialize(nbt.func_74775_l("box"));
    }

}
