/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.utils;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;

public final class CraftingUtils {

    /** Deactivate constructor */
    private CraftingUtils() {}

    public static IRecipe findMatchingRecipe(InventoryCrafting par1InventoryCrafting, World par2World) {
        // Begin repair recipe handler
        int itemNum = 0;
        ItemStack item1 = null;
        ItemStack item2 = null;
        int slot;

        for (slot = 0; slot < par1InventoryCrafting.func_70302_i_(); ++slot) {
            ItemStack itemInSlot = par1InventoryCrafting.func_70301_a(slot);

            if (itemInSlot != null) {
                if (itemNum == 0) {
                    item1 = itemInSlot;
                }

                if (itemNum == 1) {
                    item2 = itemInSlot;
                }

                ++itemNum;
            }
        }

        if (itemNum == 2 && item1 != null && item2 != null && item1.func_77973_b() == item2.func_77973_b() && item1.field_77994_a == 1 && item2.field_77994_a == 1
            && item1.func_77973_b().isRepairable()) {
            Item itemBase = item1.func_77973_b();
            int item1Durability = itemBase.func_77612_l() - item1.func_77952_i();
            int item2Durability = itemBase.func_77612_l() - item2.func_77952_i();
            int repairAmt = item1Durability + item2Durability + itemBase.func_77612_l() * 5 / 100;
            int newDamage = itemBase.func_77612_l() - repairAmt;

            if (newDamage < 0) {
                newDamage = 0;
            }

            List<ItemStack> ingredients = new ArrayList<>(2);
            ingredients.add(item1);
            ingredients.add(item2);

            return new ShapelessRecipes(new ItemStack(item1.func_77973_b(), 1, newDamage), ingredients);
        } else if (itemNum > 0) {
            // End repair recipe handler

            List<IRecipe> recipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe recipe : recipes) {

                if (recipe.func_77569_a(par1InventoryCrafting, par2World)) {
                    return recipe;
                }
            }

            return null;
        } else {
            // No items - no recipe!

            return null;
        }
    }

}
