/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.utils;

import javax.vecmath.Matrix4f;

import net.minecraft.util.EnumFacing;

/** Use {@link Matrix4f} goddammit! */
@Deprecated
public final class MatrixTranformations {

    /** Deactivate constructor */
    private MatrixTranformations() {}

    /** Mirrors the array on the Y axis by calculating offsets from 0.5F
     *
     * @param targetArray */
    public static void mirrorY(float[][] targetArray) {
        float temp = targetArray[1][0];
        targetArray[1][0] = (targetArray[1][1] - 0.5F) * -1F + 0.5F; // 1 -> 0.5F -> -0.5F -> 0F
        targetArray[1][1] = (temp - 0.5F) * -1F + 0.5F; // 0 -> -0.5F -> 0.5F -> 1F
    }

    /** Shifts the coordinates around effectively rotating something. Zero state is DOWN then -&gt; NORTH -&gt; WEST
     * Note - To obtain Position, do a mirrorY() before rotating
     *
     * @param targetArray the array that should be rotated */
    public static void rotate(float[][] targetArray) {
        for (int i = 0; i < 2; i++) {
            float temp = targetArray[2][i];
            targetArray[2][i] = targetArray[1][i];
            targetArray[1][i] = targetArray[0][i];
            targetArray[0][i] = temp;
        }
    }

    /** @param targetArray the array that should be transformed
     * @param direction */
    public static void transform(float[][] targetArray, EnumFacing direction) {
        if ((direction.ordinal() & 0x1) == 1) {
            mirrorY(targetArray);
        }

        for (int i = 0; i < (direction.ordinal() >> 1); i++) {
            rotate(targetArray);
        }
    }

    /** Clones both dimensions of a float[][]
     *
     * @param source the float[][] to deepClone */
    public static float[][] deepClone(float[][] source) {
        float[][] target = source.clone();
        for (int i = 0; i < target.length; i++) {
            target[i] = source[i].clone();
        }
        return target;
    }
}
