package buildcraft.core.lib.utils;

import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public final class ThreadSafeUtils {
    private static final ThreadLocal<Chunk> lastChunk = new ThreadLocal<>();

    private ThreadSafeUtils() {

    }

    public static Chunk getChunk(World world, int x, int z) {
        Chunk chunk;
        chunk = lastChunk.get();

        if (chunk != null) {
            if (chunk.func_177410_o()) {
                if (chunk.func_177412_p() == world && chunk.field_76635_g == x && chunk.field_76647_h == z) {
                    return chunk;
                }
            } else {
                lastChunk.set(null);
            }
        }

        IChunkProvider provider = world.func_72863_F();
        // These probably won't guarantee full thread safety, but it's our best bet.
        if (!Utils.CAULDRON_DETECTED && provider instanceof ChunkProviderServer) {
            // Slight optimization
            chunk = (Chunk) ((ChunkProviderServer) provider).field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a(x, z));
        } else {
            chunk = provider.func_73149_a(x, z) ? provider.func_73154_d(x, z) : null;
        }

        if (chunk != null) {
            lastChunk.set(chunk);
        }
        return chunk;
    }
}
