package buildcraft.core.lib.world;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase.SpawnListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.enums.EnumDecoratedBlock;
import buildcraft.api.properties.BuildCraftProperties;

import net.minecraft.world.biome.BiomeGenBase.SpawnListEntry;
public class FakeChunkProvider implements IChunkProvider {
    private Map<ChunkCoordIntPair, Chunk> chunks = Maps.newHashMap();
    private final FakeWorld world;
    private final EnumDecoratedBlock type;

    public FakeChunkProvider(FakeWorld world, EnumDecoratedBlock decor) {
        this.world = world;
        this.type = decor;
    }

    @Override
    public boolean func_73149_a(int x, int z) {
        return chunks.containsKey(new ChunkCoordIntPair(x, z));
    }

    @Override
    public Chunk func_73154_d(int chunkXPos, int chunkZPos) {
        ChunkCoordIntPair ccip = new ChunkCoordIntPair(chunkXPos, chunkZPos);
        if (!chunks.containsKey(ccip)) {
            IBlockState state = BuildCraftCore.decoratedBlock.func_176223_P();
            state = state.func_177226_a(BuildCraftProperties.DECORATED_BLOCK, type);
            ChunkPrimer primer = new ChunkPrimer();
            for (int x = 0; x < 16; x++) {
                for (int z = 0; z < 16; z++) {
                    primer.func_177855_a(x, 0, z, state);
                }
            }
            Chunk chunk = new Chunk(world, primer, chunkXPos, chunkZPos);
            for (int i = 0; i < chunk.func_76605_m().length; i++) {
                chunk.func_76605_m()[i] = 0;
            }
            chunk.func_76603_b();
            chunks.put(ccip, chunk);
            BCLog.logger.info("Created a new chunk @ " + ccip);
        }
        return chunks.get(ccip);
    }

    @Override
    public Chunk func_177459_a(BlockPos pos) {
        return func_73154_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    @Override
    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {}

    @Override
    public boolean func_177460_a(IChunkProvider p_177460_1_, Chunk p_177460_2_, int p_177460_3_, int p_177460_4_) {
        return false;
    }

    @Override
    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    @Override
    public boolean func_73156_b() {
        return false;
    }

    @Override
    public boolean func_73157_c() {
        return false;
    }

    @Override
    public String func_73148_d() {
        return "";
    }

    @Override
    public List<SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return null;
    }

    @Override
    public int func_73152_e() {
        return chunks.size();
    }

    @Override
    public void func_180514_a(Chunk p_180514_1_, int p_180514_2_, int p_180514_3_) {}

    @Override
    public void func_104112_b() {}
}
