package buildcraft.core.lib.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.SaveHandlerMP;
import net.minecraft.world.storage.WorldInfo;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.enums.EnumDecoratedBlock;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.builders.blueprints.RealBlueprintDeployer;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.Template;
import buildcraft.core.lib.utils.Utils;

public class FakeWorld extends World {
    public boolean isDirty = true;
    public volatile boolean hasDeployed = false;

    private FakeWorld(EnumDecoratedBlock type) {
        super(new SaveHandlerMP(), new WorldInfo(new NBTTagCompound()), new FakeWorldProvider(), Minecraft.func_71410_x().field_71424_I, false);
        field_73020_y = new FakeChunkProvider(this, type);
        field_73011_w.func_76558_a(this);
    }

    public FakeWorld(final Blueprint blueprint) {
        this(EnumDecoratedBlock.TEMPLATE);
        BlockPos start = blueprint.getBoxForPos(BlockPos.field_177992_a).center();
        start = start.func_177982_a(0, -start.func_177956_o() + 1, 0);

        final BlockPos deployPos = start.func_177971_a(blueprint.size).func_177973_b(Utils.POS_ONE);
        final FakeWorld thisWorld = this;
        new Thread("blueprint-deployer") {
            @Override
            public void run() {
                RealBlueprintDeployer.realInstance.deployBlueprint(thisWorld, deployPos, EnumFacing.EAST, blueprint);
                hasDeployed = true;
            }
        }.start();

        start = start.func_177977_b();
        BlockPos end = start.func_177982_a(blueprint.size.func_177958_n() - 1, 0, blueprint.size.func_177952_p() - 1);

        IBlockState state = BuildCraftCore.decoratedBlock.func_176223_P();
        state = state.func_177226_a(BuildCraftProperties.DECORATED_BLOCK, EnumDecoratedBlock.BLUEPRINT);

        IBlockState roofState = Blocks.field_150346_d.func_176223_P();

        for (BlockPos pos : BlockPos.func_177980_a(start, end)) {
            func_175656_a(pos, state);
            func_175656_a(pos.func_177981_b(255), roofState);
        }
    }

    public FakeWorld(Template template, IBlockState filledBlock) {
        this(EnumDecoratedBlock.BLUEPRINT);
        BlockPos start = template.getBoxForPos(BlockPos.field_177992_a).center();
        BlockPos end = start.func_177971_a(template.size).func_177973_b(Utils.POS_ONE);

        IBlockState state = BuildCraftCore.decoratedBlock.func_176223_P();
        state = state.func_177226_a(BuildCraftProperties.DECORATED_BLOCK, EnumDecoratedBlock.TEMPLATE);

        IBlockState roofState = Blocks.field_150346_d.func_176223_P();

        for (BlockPos pos : BlockPos.func_177980_a(start, end)) {
            BlockPos array = pos.func_177973_b(start);
            SchematicBlockBase block = template.get(array);

            if (block != null) {
                func_175656_a(pos, filledBlock);
            }
            if (pos.func_177956_o() == 1) {
                func_175656_a(pos.func_177977_b(), state);
                func_175656_a(pos.func_177981_b(254), roofState);
            }
        }
    }

    @Override
    protected IChunkProvider func_72970_h() {
        return field_73020_y;
    }

    @Override
    protected int func_152379_p() {
        return 10;
    }
}
