package buildcraft.core.lib.world;

import java.util.EnumMap;

import com.google.common.collect.Maps;

import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.client.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;

public class FakeWorldManager {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final BlockPos min, max;
    private final FakeWorld world;
    // private final RenderGlobal renderGlobal;
    // private final ChunkRenderDispatcher chunkBatcher;
    // private final Map<BlockPos, RenderChunk> chunks = Maps.newHashMap();
    private final EnumMap<EnumWorldBlockLayer, Tessellator> tessMap = Maps.newEnumMap(EnumWorldBlockLayer.class);
    private final EnumMap<EnumWorldBlockLayer, Integer> displayListMap = Maps.newEnumMap(EnumWorldBlockLayer.class);

    public FakeWorldManager(FakeWorld world) {
        this.world = world;
        for (EnumWorldBlockLayer layer : EnumWorldBlockLayer.values()) {
            tessMap.put(layer, new Tessellator(1 << 16));
        }
        world.func_72835_b();

        // Minecraft mc = Minecraft.getMinecraft();
        // renderGlobal = mc.renderGlobal;
        // chunkBatcher = new ChunkRenderDispatcher();
        min = new BlockPos(-64, 0, -64);
        max = new BlockPos(64, 8, 64);
        // for (int x = min.getX(); x < max.getX(); x += 16) {
        // for (int y = min.getY(); y < max.getY(); y += 16) {
        // for (int z = min.getZ(); z < max.getZ(); z += 16) {
        // BlockPos pos = new BlockPos(x, y, z);
        // RenderChunk chunk = new ListedRenderChunk(world, renderGlobal, min, 0);
        // chunks.put(pos, chunk);
        // chunkBatcher.updateChunkNow(chunk);
        // }
        // }
        // }
        // while (chunkBatcher.runChunkUploads(0));
    }

    public void deleteAll() {
        for (int list : displayListMap.values()) {
            GL11.glDeleteLists(list, 1);
        }
        displayListMap.clear();
    }

    public void renderWorld(double mouseX, double mouseY, double sf, BlockPos offset) {
        // Prepare
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();

        GlStateManager.func_179094_E();
        GL11.glTranslated(0, 0, 2000 - sf);
        // GlStateManager.scale(sf, sf, sf);

        GL11.glMatrixMode(GL11.GL_PROJECTION);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float aspect = mc.field_71443_c / (float) mc.field_71440_d;
        Project.gluPerspective(mc.field_71474_y.field_74334_X, aspect, 0.01f, mc.field_71474_y.field_151451_c * 1000);

        GL11.glMatrixMode(GL11.GL_MODELVIEW);
        GL11.glRotated(mouseY, 1, 0, 0);
        GL11.glRotated(mouseX, 0, 1, 0);

        RenderUtils.translate(Utils.multiply(Utils.convert(offset), -0.5));

        renderAll();

        GL11.glMatrixMode(GL11.GL_PROJECTION);
        GlStateManager.func_179121_F();
        GL11.glMatrixMode(GL11.GL_MODELVIEW);
        GlStateManager.func_179121_F();
    }

    private void renderAll() {
        GlStateManager.func_179118_c();
        // Solids
        EnumWorldBlockLayer layer = EnumWorldBlockLayer.SOLID;
        renderAllChunks(layer);

        // Cutouts (That have mipmapping applied)
        layer = EnumWorldBlockLayer.CUTOUT_MIPPED;
        GlStateManager.func_179141_d();
        renderAllChunks(layer);

        // Cutouts (That don't have mipmapping applied)
        layer = EnumWorldBlockLayer.CUTOUT;
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        renderAllChunks(layer);

        // Cutout tear-down
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179103_j(7424);
        GlStateManager.func_179092_a(516, 0.1F);

        // Translucent (Partial alpha)
        layer = EnumWorldBlockLayer.TRANSLUCENT;
        if (mc.field_71474_y.field_74347_j) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA, GL11.GL_ONE, GL11.GL_ZERO);
            renderAllChunks(layer);
            GlStateManager.func_179084_k();
        } else {
            renderAllChunks(layer);
        }
    }

    private void renderAllChunks(EnumWorldBlockLayer layer) {
        Tessellator tess = tessMap.get(layer);
        WorldRenderer renderer = tess.func_178180_c();
        if (displayListMap.containsKey(layer)) {
            GL11.glCallList(displayListMap.get(layer));
            // tess.draw();
        } else if (world.hasDeployed) {
            int list = GLAllocation.func_74526_a(1);
            GL11.glNewList(list, GL11.GL_COMPILE);
            renderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
            renderAllBlocks(layer, renderer);
            tess.func_78381_a();
            GL11.glEndList();
            displayListMap.put(layer, list);
        }
    }

    private void renderAllBlocks(EnumWorldBlockLayer layer, WorldRenderer renderer) {
        for (ChunkCoordIntPair ccip : Utils.allChunksFor(min, max)) {
            if (world.func_72863_F().func_73149_a(ccip.field_77276_a, ccip.field_77275_b)) {
                Chunk chunk = world.func_72964_e(ccip.field_77276_a, ccip.field_77275_b);
                boolean hasObj = false;
                for (int h : chunk.func_177445_q()) {
                    if (h > 1) {
                        hasObj = true;
                        break;
                    }
                }
                if (!hasObj) {
                    continue;
                }
                for (BlockPos pos : Utils.allInChunk(ccip)) {
                    renderBlock(pos, layer, renderer);
                }
            }
        }
    }

    private void renderBlock(BlockPos pos, EnumWorldBlockLayer layer, WorldRenderer renderer) {
        IBlockState actualState = world.func_180495_p(pos);
        Block block = actualState.func_177230_c();
        if (block == Blocks.field_150350_a || block == null) {
            return;
        }

        if (!block.canRenderInLayer(layer)) {
            return;
        }

        actualState = block.func_176221_a(actualState, world, pos);

        BlockRendererDispatcher dispatcher = mc.func_175602_ab();

        IBakedModel model = dispatcher.func_175023_a().func_178125_b(actualState);

        if (model == null || model.func_177554_e() == null || model.func_177550_a() == null) {
            return;
        }

        boolean checkSides = pos.func_177956_o() > 0;
        try {
            dispatcher.func_175019_b().func_178258_b(world, model, block, pos, renderer, checkSides);
        } catch (Throwable t) {
            BCLog.logger.warn("The model from the block " + block + " was invalid for layer " + layer, t);
        }
    }
}
