/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.list;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import net.minecraftforge.fml.relauncher.Side;

import buildcraft.BuildCraftCore;
import buildcraft.core.ItemList;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;

import io.netty.buffer.ByteBuf;

public class ContainerList extends BuildCraftContainer implements ICommandReceiver {
    public ListHandler.Line[] lines;
    private EntityPlayer player;

    public ContainerList(EntityPlayer iPlayer) {
        super(iPlayer, iPlayer.field_71071_by.func_70302_i_());

        player = iPlayer;

        lines = ListHandler.getLines(player.func_71045_bC());

        for (int sy = 0; sy < 3; sy++) {
            for (int sx = 0; sx < 9; sx++) {
                func_75146_a(new Slot(player.field_71071_by, sx + sy * 9 + 9, 8 + sx * 18, 103 + sy * 18));
            }
        }

        for (int sx = 0; sx < 9; sx++) {
            func_75146_a(new Slot(player.field_71071_by, sx, 8 + sx * 18, 161));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void setStack(final int lineIndex, final int slotIndex, final ItemStack stack) {
        lines[lineIndex].setStack(slotIndex, stack);
        ListHandler.saveLines(player.func_71045_bC(), lines);

        if (player.field_70170_p.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setStack", new CommandWriter() {
                @Override
                public void write(ByteBuf data) {
                    data.writeByte(lineIndex);
                    data.writeByte(slotIndex);
                    NetworkUtils.writeStack(data, stack);
                }
            }));
        }
    }

    public void switchButton(final int lineIndex, final int button) {
        lines[lineIndex].toggleOption(button);
        ListHandler.saveLines(player.func_71045_bC(), lines);

        if (player.field_70170_p.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "switchButton", new CommandWriter() {
                @Override
                public void write(ByteBuf data) {
                    data.writeByte(lineIndex);
                    data.writeByte(button);
                }
            }));
        }
    }

    public void setLabel(final String text) {
        ItemList.saveLabel(player.func_71045_bC(), text);

        if (player.field_70170_p.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setLabel", new CommandWriter() {
                @Override
                public void write(ByteBuf data) {
                    NetworkUtils.writeUTF(data, text);
                }
            }));
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer()) {
            if ("setLabel".equals(command)) {
                setLabel(NetworkUtils.readUTF(stream));
            } else if ("switchButton".equals(command)) {
                switchButton(stream.readUnsignedByte(), stream.readUnsignedByte());
            } else if ("setStack".equals(command)) {
                setStack(stream.readUnsignedByte(), stream.readUnsignedByte(), NetworkUtils.readStack(stream));
            }
        }
    }
}
