/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.list;

import java.io.IOException;
import java.util.*;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

import buildcraft.BuildCraftCore;
import buildcraft.api.lists.ListMatchHandler;
import buildcraft.core.ItemList;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.buttons.GuiImageButton;
import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.inventory.StackHelper;

public class GuiList extends GuiAdvancedInterface implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftcore:textures/gui/list_new.png");
    private static final int BUTTON_COUNT = 3;

    private final Map<Integer, Map<ListMatchHandler.Type, List<ItemStack>>> exampleCache =
        new HashMap<>();
    private GuiTextField textField;
    private EntityPlayer player;

    private static class ListSlot extends AdvancedSlot {
        public int lineIndex;
        public int slotIndex;

        public ListSlot(GuiAdvancedInterface gui, int x, int y, int iLineIndex, int iSlotIndex) {
            super(gui, x, y);

            lineIndex = iLineIndex;
            slotIndex = iSlotIndex;
        }

        @Override
        public ItemStack getItemStack() {
            ContainerList container = (ContainerList) gui.getContainer();
            if (slotIndex == 0 || !container.lines[lineIndex].isOneStackMode()) {
                return container.lines[lineIndex].getStack(slotIndex);
            } else {
                List<ItemStack> data = ((GuiList) gui).getExamplesList(lineIndex, container.lines[lineIndex].getSortingType());
                if (data.size() >= slotIndex) {
                    return data.get(slotIndex - 1);
                } else {
                    return null;
                }
            }
        }

        @Override
        public void drawSprite(int cornerX, int cornerY) {
            if (!shouldDrawHighlight()) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_BASE);
                gui.func_73729_b(cornerX + x, cornerY + y, 176, 0, 16, 16);
            }

            super.drawSprite(cornerX, cornerY);
        }

        @Override
        public boolean shouldDrawHighlight() {
            ContainerList container = (ContainerList) gui.getContainer();
            return slotIndex == 0 || !container.lines[lineIndex].isOneStackMode();
        }
    }

    public GuiList(EntityPlayer iPlayer) {
        super(new ContainerList(iPlayer), iPlayer.field_71071_by, TEXTURE_BASE);

        field_146999_f = 176;
        field_147000_g = 191;

        player = iPlayer;
    }

    private void clearExamplesCache(int lineId) {
        Map<ListMatchHandler.Type, List<ItemStack>> exampleList = exampleCache.get(lineId);
        if (exampleList != null) {
            exampleList.clear();
        }
    }

    private List<ItemStack> getExamplesList(int lineId, ListMatchHandler.Type type) {
        Map<ListMatchHandler.Type, List<ItemStack>> exampleList = exampleCache.get(lineId);
        if (exampleList == null) {
            exampleList = new EnumMap<>(ListMatchHandler.Type.class);
            exampleCache.put(lineId, exampleList);
        }

        ContainerList container = (ContainerList) getContainer();

        if (!exampleList.containsKey(type)) {
            List<ItemStack> examples = container.lines[lineId].getExamples();
            ItemStack input = container.lines[lineId].stacks[0];
            if (input != null) {
                List<ItemStack> repetitions = new ArrayList<>();
                for (ItemStack is : examples) {
                    if (StackHelper.isMatchingItem(input, is, true, false)) {
                        repetitions.add(is);
                    }
                }
                examples.removeAll(repetitions);
            }
            exampleList.put(type, examples);
        }
        return exampleList.get(type);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();

        exampleCache.clear();
        slots.clear();
        field_146292_n.clear();

        for (int sy = 0; sy < ListHandler.HEIGHT; sy++) {
            for (int sx = 0; sx < ListHandler.WIDTH; sx++) {
                slots.add(new ListSlot(this, 8 + sx * 18, 32 + sy * 33, sy, sx));
            }
            int bOff = sy * BUTTON_COUNT;
            int bOffX = this.field_147003_i + 8 + ListHandler.WIDTH * 18 - BUTTON_COUNT * 11;
            int bOffY = this.field_147009_r + 32 + sy * 33 + 18;

            field_146292_n.add(new GuiImageButton(bOff + 0, bOffX, bOffY, 11, TEXTURE_BASE, 176, 16, 176, 28));
            field_146292_n.add(new GuiImageButton(bOff + 1, bOffX + 11, bOffY, 11, TEXTURE_BASE, 176, 16, 185, 28));
            field_146292_n.add(new GuiImageButton(bOff + 2, bOffX + 22, bOffY, 11, TEXTURE_BASE, 176, 16, 194, 28));
        }

        for (Object o : field_146292_n) {
            GuiImageButton b = (GuiImageButton) o;
            int lineId = b.field_146127_k / BUTTON_COUNT;
            int buttonId = b.field_146127_k % BUTTON_COUNT;
            if (((ContainerList) getContainer()).lines[lineId].getOption(buttonId)) {
                b.activate();
            }

            b.registerListener(this);
        }

        textField = new GuiTextField(6, this.field_146289_q, 10, 10, 156, 12);
        textField.func_146203_f(32);
        textField.func_146180_a(BuildCraftCore.listItem.getLabel(player.func_71045_bC()));
        textField.func_146195_b(false);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);

        ContainerList containerL = (ContainerList) getContainer();
        for (int i = 0; i < 2; i++) {
            if (containerL.lines[i].isOneStackMode()) {
                func_73729_b(field_147003_i + 6, field_147009_r + 30 + i * 33, 0, field_147000_g, 20, 20);
            }
        }

        drawBackgroundSlots(x, y);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);

        textField.func_146194_f();
        drawTooltipForSlotAt(par1, par2);
    }

    private boolean isCarryingNonEmptyList() {
        ItemStack stack = field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        return stack != null && stack.func_77973_b() instanceof ItemList && stack.func_77978_p() != null;
    }

    private boolean hasListEquipped() {
        return field_146297_k.field_71439_g.func_71045_bC() != null && field_146297_k.field_71439_g.func_71045_bC().func_77973_b() instanceof ItemList;
    }

    @Override
    protected void func_73864_a(int x, int y, int b) throws IOException {
        super.func_73864_a(x, y, b);

        if (isCarryingNonEmptyList() || !hasListEquipped()) {
            return;
        }

        AdvancedSlot slot = getSlotAtLocation(x, y);
        ContainerList container = (ContainerList) getContainer();

        if (slot instanceof ListSlot) {
            container.setStack(((ListSlot) slot).lineIndex, ((ListSlot) slot).slotIndex, field_146297_k.field_71439_g.field_71071_by.func_70445_o());
            clearExamplesCache(((ListSlot) slot).lineIndex);
        }

        textField.func_146192_a(x - field_147003_i, y - field_147009_r, b);
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger sender, int id) {
        int buttonId = id % BUTTON_COUNT;
        int lineId = id / BUTTON_COUNT;

        ContainerList container = (ContainerList) getContainer();
        container.switchButton(lineId, buttonId);
        clearExamplesCache(lineId);
    }

    @Override
    protected void func_73869_a(char c, int i) throws IOException {
        if (textField.func_146206_l()) {
            if (c == 13 || c == 27) {
                textField.func_146195_b(false);
            } else {
                textField.func_146201_a(c, i);
                ((ContainerList) container).setLabel(textField.func_146179_b());
            }
        } else {
            super.func_73869_a(c, i);
        }
    }
}
