/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.Chunk.EnumCreateEntityType;

import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

import buildcraft.BuildCraftCore;
import buildcraft.core.EntityLaser;
import buildcraft.core.TileMarker;
import buildcraft.core.TilePathMarker;
import buildcraft.core.client.BuildCraftStateMapper;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.client.render.RenderResizableCuboid;
import buildcraft.core.lib.config.DetailedConfigOption;
import buildcraft.core.lib.engines.RenderEngine;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.utils.ICustomStateMapper;
import buildcraft.core.lib.utils.IModelRegister;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.render.RenderLaser;
import buildcraft.core.render.RenderMarker;
import buildcraft.core.render.RenderPathMarker;

import net.minecraft.world.chunk.Chunk.EnumCreateEntityType;
public class CoreProxyClient extends CoreProxy {

    /* INSTANCES */
    @Override
    public Object getClient() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    /* ENTITY HANDLING */
    @Override
    public void removeEntity(Entity entity) {
        super.removeEntity(entity);

        if (entity.field_70170_p.field_72995_K) {
            ((WorldClient) entity.field_70170_p).func_73028_b(entity.func_145782_y());
        }
    }

    /* WRAPPER */
    @Override
    public String getItemDisplayName(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return "";
        }

        return stack.func_82833_r();
    }

    @Override
    public void init() {
        ((IReloadableResourceManager) Minecraft.func_71410_x().func_110442_L()).func_110542_a(
                DetailedConfigOption.ReloadListener.INSTANCE);

        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineBase.class, new RenderEngine());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePathMarker.class, new RenderPathMarker());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMarker.class, new RenderMarker());

        RenderingRegistry.registerEntityRenderingHandler(EntityResizableCuboid.class, RenderResizableCuboid.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityLaser.class, new RenderLaser());

        for (Block block : blocksToRegisterRenderersFor) {
            if (block instanceof IModelRegister) {
                ((IModelRegister) block).registerModels();
                continue;
            }

            IBlockState defaultState = block.func_176223_P();
            Multimap<Integer, IBlockState> metaStateMap = ArrayListMultimap.create();
            Map<IBlockState, String> stateTypeMap = Maps.newHashMap();

            for (IBlockState state : (List<IBlockState>) block.func_176194_O().func_177619_a()) {
                String type = BuildCraftStateMapper.getPropertyString(state);
                stateTypeMap.put(state, type);
                metaStateMap.put(block.func_180651_a(state), state);
            }
            for (Entry<Integer, Collection<IBlockState>> entry : metaStateMap.asMap().entrySet()) {
                Collection<IBlockState> blockStates = entry.getValue();
                if (blockStates.isEmpty()) continue;
                if (blockStates.contains(defaultState)) {
                    registerBlockItemModel(defaultState, entry.getKey(), stateTypeMap.get(defaultState));
                } else {
                    IBlockState state = blockStates.iterator().next();
                    registerBlockItemModel(state, entry.getKey(), stateTypeMap.get(state));
                }
            }
        }
        for (Item item : itemsToRegisterRenderersFor) {
            if (item instanceof IModelRegister) {
                ((IModelRegister) item).registerModels();
            }
        }
    }

    private void registerBlockItemModel(IBlockState state, int meta, String type) {
        Block block = state.func_177230_c();
        ModelResourceLocation location = new ModelResourceLocation(Utils.getNameForBlock(block).replace("|", ""), type.toLowerCase());
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a(block), meta, location);
    }

    /* BUILDCRAFT PLAYER */
    @Override
    public String playerName() {
        return FMLClientHandler.instance().getClient().field_71439_g.getDisplayNameString();
    }

    /** This function returns either the player from the handler if it's on the server, or directly from the minecraft
     * instance if it's the client. */
    @Override
    public EntityPlayer getPlayerFromNetHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return super.getPlayerFromNetHandler(handler);
        } else {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }

    private LinkedList<Block> blocksToRegisterRenderersFor = new LinkedList<>();
    private LinkedList<Item> itemsToRegisterRenderersFor = new LinkedList<>();

    @Override
    public void postRegisterBlock(Block block) {
        blocksToRegisterRenderersFor.add(block);
        if (block instanceof ICustomStateMapper) {
            ((ICustomStateMapper) block).setCusomStateMappers();
        } else {
            ModelLoader.setCustomStateMapper(block, BuildCraftStateMapper.INSTANCE);
        }
    }

    @Override
    public void postRegisterItem(Item item) {
        itemsToRegisterRenderersFor.add(item);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public <T extends TileEntity> T getServerTile(T source) {
        if (BuildCraftCore.useServerDataOnClient && Minecraft.func_71410_x().func_71356_B() && source.func_145831_w().field_72995_K) {
            WorldServer w = DimensionManager.getWorld(source.func_145831_w().field_73011_w.func_177502_q());
            if (w != null && w.func_72863_F() != null) {
                Chunk c = w.func_175726_f(source.func_174877_v());
                if (c != null) {
                    TileEntity t = c.func_177424_a(source.func_174877_v(), EnumCreateEntityType.CHECK);
                    if (t != null && t.getClass().equals(source.getClass())) {
                        return (T) t;
                    }
                }
            }
        }
        return source;
    }

    @Override
    public InputStream getStreamForResource(ResourceLocation location) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            return resource.func_110527_b();
        } catch (IOException e) {
            return null;
        }
    }
}
