/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.render;

import org.lwjgl.opengl.GL11;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.*;

import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.core.lib.client.render.ICustomHighlight;

public class BlockHighlightHandler {
    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void handleBlockHighlight(DrawBlockHighlightEvent e) {
        if (e.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = MathHelper.func_76128_c(e.target.field_72307_f.field_72450_a);
            int y = MathHelper.func_76128_c(e.target.field_72307_f.field_72448_b);
            int z = MathHelper.func_76128_c(e.target.field_72307_f.field_72449_c);

            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = e.player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();

            if (block instanceof ICustomHighlight) {
                AxisAlignedBB[] aabbs = ((ICustomHighlight) block).getBoxes(e.player.field_70170_p, pos, state);
                Vec3 nPos = e.player.func_174824_e(e.partialTicks).func_178786_a(0, e.player.func_70047_e(), 0);

                // Highlight "breathing"
                long millis = System.currentTimeMillis();
                float expansion = (millis % 5000) / 2500F - 1;
                expansion *= Math.PI * 2;
                expansion = (MathHelper.func_76126_a(expansion) + 1) / 2;
                expansion *= ((ICustomHighlight) block).getBreathingCoefficent();

                GL11.glEnable(GL11.GL_BLEND);
                OpenGlHelper.func_148821_a(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA, GL11.GL_ONE, GL11.GL_ZERO);
                GL11.glColor4f(0.0F, 0.0F, 0.0F, 0.4F);
                GL11.glLineWidth(2F);
                GL11.glDisable(GL11.GL_TEXTURE_2D);
                GL11.glDepthMask(false);

                double exp = ((ICustomHighlight) block).getExpansion();
                exp += expansion / 32D;
                nPos = nPos.func_178786_a(x, y, z);
                for (AxisAlignedBB aabb : aabbs) {
                    AxisAlignedBB changed = aabb.func_72314_b(exp, exp, exp).func_72317_d(-nPos.field_72450_a, -nPos.field_72448_b, -nPos.field_72449_c);
                    RenderGlobal.func_181561_a(changed);
                }

                GL11.glDepthMask(true);
                GL11.glEnable(GL11.GL_TEXTURE_2D);
                GL11.glDisable(GL11.GL_BLEND);
                e.setCanceled(true);
            }
        }
    }
}
