/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.render;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

import buildcraft.core.Box;
import buildcraft.core.EntityLaser;
import buildcraft.core.internal.IBoxProvider;
import buildcraft.core.internal.IBoxesProvider;

public class RenderBoxProvider<T extends TileEntity> extends TileEntitySpecialRenderer<T> {
    public RenderBoxProvider() {}

    @Override
    public boolean func_181055_a() {
        return true;
    }

    @Override
    public void func_180535_a(T tileentity, double x, double y, double z, float f, int anArgument) {
        GL11.glPushMatrix();
        GL11.glPushAttrib(GL11.GL_ENABLE_BIT);
        GlStateManager.func_179089_o();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

        GL11.glPushMatrix();
        GL11.glTranslated(-tileentity.func_174877_v().func_177958_n(), -tileentity.func_174877_v().func_177956_o(), -tileentity.func_174877_v().func_177952_p());
        GL11.glTranslated(x, y, z);

        if (tileentity instanceof IBoxesProvider) {
            for (Box b : ((IBoxesProvider) tileentity).getBoxes()) {
                if (b.isVisible) {
                    RenderBox.doRender(TileEntityRendererDispatcher.field_147556_a.field_147550_f, Minecraft.func_71410_x().field_71446_o, getTexture(b.kind), b);
                }
            }
        } else if (tileentity instanceof IBoxProvider) {
            Box b = ((IBoxProvider) tileentity).getBox();

            if (b.isVisible && b.isInitialized()) {
                RenderBox.doRender(TileEntityRendererDispatcher.field_147556_a.field_147550_f, Minecraft.func_71410_x().field_71446_o, getTexture(b.kind), b);
            }
        }

        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private ResourceLocation getTexture(Box.Kind kind) {
        switch (kind) {
            case LASER_RED:
                return EntityLaser.LASER_RED;
            case LASER_YELLOW:
                return EntityLaser.LASER_YELLOW;
            case LASER_GREEN:
                return EntityLaser.LASER_GREEN;
            case LASER_BLUE:
                return EntityLaser.LASER_BLUE;
            case STRIPES:
                return EntityLaser.LASER_STRIPES_YELLOW;
            case BLUE_STRIPES:
                return EntityLaser.LASER_STRIPES_BLUE;
        }

        return null;
    }
}
