package buildcraft.core.render;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;

import buildcraft.core.EntityLaser;
import buildcraft.core.LaserData;
import buildcraft.core.TileMarker;

public class RenderMarker extends TileEntitySpecialRenderer<TileMarker> {
    @Override
    public void func_180535_a(TileMarker marker, double x, double y, double z, float partialTicks, int destroyStage) {
        if (marker != null) {

            Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
            Minecraft.func_71410_x().field_71424_I.func_76320_a("marker");
            GL11.glPushMatrix();
            GL11.glPushAttrib(GL11.GL_ENABLE_BIT);

            GL11.glTranslated(x, y, z);
            GL11.glTranslated(-marker.func_174877_v().func_177958_n(), -marker.func_174877_v().func_177956_o(), -marker.func_174877_v().func_177952_p());

            Minecraft.func_71410_x().field_71424_I.func_76320_a("laser");

            if (marker.lasers != null) for (LaserData laser : marker.lasers) {
                if (laser != null) {
                    GL11.glPushMatrix();
                    RenderLaser.doRenderLaser(TileEntityRendererDispatcher.field_147556_a.field_147550_f, Minecraft.func_71410_x().field_71446_o, laser,
                            EntityLaser.LASER_RED);
                    GL11.glPopMatrix();
                }
            }

            Minecraft.func_71410_x().field_71424_I.func_76318_c("signal");

            if (marker.signals != null) for (LaserData laser : marker.signals) {
                if (laser != null) {
                    GL11.glPushMatrix();
                    RenderLaser.doRenderLaser(TileEntityRendererDispatcher.field_147556_a.field_147550_f, Minecraft.func_71410_x().field_71446_o, laser,
                            EntityLaser.LASER_BLUE);
                    GL11.glPopMatrix();
                }
            }
            Minecraft.func_71410_x().field_71424_I.func_76319_b();

            GL11.glPopAttrib();
            GL11.glPopMatrix();

            Minecraft.func_71410_x().field_71424_I.func_76319_b();
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    @Override
    public boolean func_181055_a() {
        return true;
    }
}
