/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.statements;

import java.util.Objects;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.ResourceLocation;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.utils.BCStringUtils;

import net.minecraft.util.EnumFacing.Axis;
public class StatementParameterDirection implements IStatementParameter {

    @SideOnly(Side.CLIENT)
    private static TextureAtlasSprite[] sprites;

    public EnumFacing direction = null;

    @SideOnly(Side.CLIENT)
    public static void registerIcons(TextureMap map) {
        sprites = new TextureAtlasSprite[6];
        sprites[0] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_down"));
        sprites[1] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_up"));
        sprites[2] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_north"));
        sprites[3] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_south"));
        sprites[4] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_west"));
        sprites[5] = map.func_174942_a(new ResourceLocation("buildcraftcore:triggers/trigger_dir_east"));
    }

    public StatementParameterDirection() {

    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (direction == null) {
            return null;
        } else {
            return sprites[direction.ordinal()];
        }
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        if (source.getTile() instanceof IPipeTile) {
            for (int i = 0; i < 6; i++) {
                direction = EnumFacing.field_82609_l[(direction.ordinal() + (mouse.getButton() > 0 ? -1 : 1)) % 6];
                if (((IPipeTile) source.getTile()).isPipeConnected(direction)) {
                    return;
                }
            }
            direction = null;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("direction", (byte) direction.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("direction")) {
            direction = EnumFacing.field_82609_l[nbt.func_74771_c("direction")];
        } else {
            direction = null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof StatementParameterDirection) {
            StatementParameterDirection param = (StatementParameterDirection) object;
            return param.direction == this.direction;
        }
        return false;
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(direction);
    }

    @Override
    public String getDescription() {
        if (direction == null) {
            return "";
        } else {
            return BCStringUtils.localize("direction." + direction.name().toLowerCase());
        }
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeActionDirection";
    }

    @Override
    public IStatementParameter rotateLeft() {
        StatementParameterDirection d = new StatementParameterDirection();
        if (d.direction != null && d.direction.func_176740_k() != Axis.Y) {
            d.direction = d.direction.func_176746_e();
        }
        return d;
    }
}
