/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.energy.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.engines.TileEngineWithInventory;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.widgets.FluidTankWidget;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.TileEngineStone;

public class ContainerEngine extends BuildCraftContainer {

    protected TileEngineWithInventory engine;

    public ContainerEngine(EntityPlayer player, TileEngineWithInventory tileEngine) {
        super(player, tileEngine.func_70302_i_());

        engine = tileEngine;

        int yOffset = 0;

        if (tileEngine instanceof TileEngineStone) {
            func_75146_a(new Slot(tileEngine, 0, 80, 41));
        } else {// Assume TileEngineIron
            TileEngineIron combustionEngine = (TileEngineIron) tileEngine;

            if (!BuildCraftCore.DEVELOPER_MODE) {
                func_75146_a(new Slot(tileEngine, 0, 52, 41));
                FluidTankWidget fuelWidget = new FluidTankWidget(combustionEngine.tankFuel, 104, 19, 16, 58).withOverlay(176, 0);
                addWidget(fuelWidget);
                addWidget(fuelWidget.copyMoved(combustionEngine.tankCoolant, 122, 19));
            } else {
                FluidTankWidget fuelWidget = new FluidTankWidget(combustionEngine.tankFuel, 26, 19, 16, 58).withOverlay(176, 0);
                addWidget(fuelWidget);
                addWidget(fuelWidget.copyMoved(combustionEngine.tankCoolant, 80, 19));
                addWidget(fuelWidget.copyMoved(combustionEngine.tankResidue, 134, 19));
                yOffset = 11;
            }
        }

        for (int i = 0; i < 3; i++) {
            for (int k = 0; k < 9; k++) {
                func_75146_a(new Slot(player.field_71071_by, k + i * 9 + 9, 8 + k * 18, 84 + i * 18 + yOffset));
            }
        }

        for (int j = 0; j < 9; j++) {
            func_75146_a(new Slot(player.field_71071_by, j, 8 + j * 18, 142 + yOffset));
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();

        for (Object crafter : field_75149_d) {
            engine.sendGUINetworkData(this, (ICrafting) crafter);
        }
    }

    @Override
    public void func_75137_b(int i, int j) {
        engine.getGUINetworkData(i, j);
    }

    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return engine.func_70300_a(entityplayer);
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return engine.func_70300_a(entityplayer);
    }
}
