/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.energy.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.energy.TileEngineIron;

public class GuiCombustionEngine extends GuiEngine {

    private static final ResourceLocation TEXTURE;

    static {
        if (BuildCraftCore.DEVELOPER_MODE) {
            TEXTURE = new ResourceLocation("buildcraftenergy:textures/gui/combustion_engine_gui.png");
        } else {
            TEXTURE = new ResourceLocation("buildcraftenergy:textures/gui/combustion_engine_gui_old.png");
        }
    }

    public GuiCombustionEngine(EntityPlayer player, TileEngineIron tileEngine) {
        super(new ContainerEngine(player, tileEngine), tileEngine, TEXTURE);
        field_147000_g = BuildCraftCore.DEVELOPER_MODE ? 177 : 166;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = BCStringUtils.localize("tile.engineIron.name");
        field_146289_q.func_78276_b(title, getCenteredOffset(title), 6, 0x404040);
        field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);
    }
}
