/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.energy.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import buildcraft.BuildCraftCore;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.Ledger;
import buildcraft.core.lib.utils.BCStringUtils;

public abstract class GuiEngine extends GuiBuildCraft {

    private static final ResourceLocation TEXTURES = TextureMap.field_110575_b;

    protected class EngineLedger extends Ledger {

        TileEngineBase engine;
        int headerColour = 0xe1c92f;
        int subheaderColour = 0xaaafb8;
        int textColour = 0x000000;

        public EngineLedger(TileEngineBase engine) {
            super(GuiEngine.this);
            this.engine = engine;
            maxHeight = 94;
            overlayColor = 0xd46c1f;
        }

        @Override
        public void draw(int x, int y) {

            // Draw background
            drawBackground(x, y);

            // Draw icon
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES);
            drawIcon(CoreIconProvider.ENERGY.getSprite(), x + 3, y + 4);

            if (!isFullyOpened()) {
                return;
            }

            field_146289_q.func_175063_a(BCStringUtils.localize("gui.energy"), x + 22, y + 8, headerColour);
            field_146289_q.func_175063_a(BCStringUtils.localize("gui.currentOutput") + ":", x + 22, y + 20, subheaderColour);
            field_146289_q.func_78276_b(String.format("%d RF/t", engine.currentOutput), x + 22, y + 32, textColour);
            field_146289_q.func_175063_a(BCStringUtils.localize("gui.stored") + ":", x + 22, y + 44, subheaderColour);
            field_146289_q.func_78276_b(String.format("%d RF", engine.getEnergyStored()), x + 22, y + 56, textColour);
            field_146289_q.func_175063_a(BCStringUtils.localize("gui.heat") + ":", x + 22, y + 68, subheaderColour);
            field_146289_q.func_78276_b(String.format("%.2f \u00B0C", engine.getCurrentHeatValue()), x + 22, y + 80, textColour);

        }

        @Override
        public String getTooltip() {
            return String.format("%d RF/t", engine.currentOutput);
        }
    }

    public GuiEngine(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            ledgerManager.add(new EngineLedger((TileEngineBase) tile));
        }
    }
}
