/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.energy.gui;

import org.lwjgl.opengl.GL11;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.energy.TileEngineStone;

public class GuiStoneEngine extends GuiEngine {

    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftenergy:textures/gui/steam_engine_gui.png");

    public GuiStoneEngine(EntityPlayer player, TileEngineStone tileEngine) {
        super(new ContainerEngine(player, tileEngine), tileEngine, TEXTURE);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = BCStringUtils.localize("tile.engineStone.name");
        field_146289_q.func_78276_b(title, getCenteredOffset(title), 6, 0x404040);
        field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);

        TileEngineStone engine = (TileEngineStone) tile;
        if (engine.getScaledBurnTime(12) > 0) {
            int l = engine.getScaledBurnTime(12);

            func_73729_b(field_147003_i + 80, (field_147009_r + 24 + 12) - l, 176, 12 - l, 14, l + 2);
        }
    }
}
