/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 *
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import buildcraft.BuildCraftFactory;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.GuiIds;
import buildcraft.core.lib.block.BlockBuildCraft;

public class BlockChute extends BlockBuildCraft {

    public BlockChute() {
        super(Material.field_151573_f);
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileChute();
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing face, float par7, float par8,
            float par9) {
        if (super.func_180639_a(world, pos, state, entityplayer, face, par7, par8, par9)) {
            return true;
        }

        if (entityplayer.func_70093_af()) {
            return false;
        }

        if (entityplayer.func_71045_bC() != null) {
            if (entityplayer.func_71045_bC().func_77973_b() instanceof IItemPipe) {
                return false;
            }
        }

        if (!world.field_72995_K) {
            entityplayer.openGui(BuildCraftFactory.instance, GuiIds.HOPPER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        return true;
    }
}
