/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import buildcraft.BuildCraftFactory;
import buildcraft.core.lib.block.BlockBuildCraft;

public class BlockMiningWell extends BlockBuildCraft {
    public BlockMiningWell() {
        super(Material.field_151578_c, LED_POWER, LED_DONE);

        func_149711_c(5F);
        func_149752_b(10F);
        func_149672_a(field_149769_e);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        removePipes(world, pos);
    }

    public void removePipes(World world, BlockPos pos) {
        for (int y = 1; y < pos.func_177956_o(); y++) {
            BlockPos down = pos.func_177979_c(y);
            Block block = world.func_180495_p(down).func_177230_c();
            if (block != BuildCraftFactory.plainPipeBlock) {
                break;
            }
            world.func_175698_g(down);
        }
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileMiningWell();
    }
}
