/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import java.util.Collections;
import java.util.List;
import java.util.Random;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;

import buildcraft.core.CoreConstants;
import buildcraft.core.lib.block.BlockBuildCraftBase;

public class BlockPlainPipe extends BlockBuildCraftBase {

    public BlockPlainPipe() {
        super(Material.field_151592_s, null, false);

        field_149759_B = CoreConstants.PIPE_MIN_POS;
        field_149760_C = 0;
        field_149754_D = CoreConstants.PIPE_MIN_POS;

        field_149755_E = CoreConstants.PIPE_MAX_POS;
        field_149756_F = 1;
        field_149757_G = CoreConstants.PIPE_MAX_POS;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149721_r() {
        return false;
    }

    @Override
    public boolean func_149730_j() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(this));
    }

    @Override
    public Item func_180660_a(IBlockState state, Random random, int j) {
        return null;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    @Override
    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    @Override
    public AxisAlignedBB getBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB(field_149759_B, field_149760_C, field_149754_D, field_149755_E, field_149756_F, field_149757_G);
    }
}
