/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.block.BlockBuildCraft;

public class BlockPump extends BlockBuildCraft {

    public BlockPump() {
        super(Material.field_151573_f, LED_POWER, LED_DONE);
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TilePump();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing face, float par7, float par8,
            float par9) {
        if (super.func_180639_a(world, pos, state, entityplayer, face, par7, par8, par9)) {
            return true;
        }

        TileEntity tile = world.func_175625_s(pos);

        if (tile instanceof TilePump) {
            TilePump pump = (TilePump) tile;

            // Drop through if the player is sneaking
            if (entityplayer.func_70093_af()) {
                return false;
            }

            // Restart the pump if its a wrench
            Item equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench) equipped).canWrench(entityplayer, pos)) {

                pump.tank.reset();
                pump.rebuildQueue();
                ((IToolWrench) equipped).wrenchUsed(entityplayer, pos);
                return true;
            }
        }

        return false;
    }

    @Override
    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        super.func_176204_a(world, pos, state, block);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePump) {
            ((TilePump) tile).onNeighborBlockChange(block);
        }
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return 1;
    }
}
