/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.World;

import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.BuildCraftFactory;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.GuiIds;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.fluids.TankUtils;

public class BlockRefinery extends BlockBuildCraft {
    public BlockRefinery() {
        super(Material.field_151573_f, FACING_PROP);

        func_149711_c(5F);
        func_149647_a(BCCreativeTab.get("main"));
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileRefinery();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY,
            float hitZ) {
        if (super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ)) {
            return true;
        }

        TileEntity tile = world.func_175625_s(pos);

        if (!(tile instanceof TileRefinery)) {
            return false;
        }

        ItemStack current = player.func_71045_bC();
        Item equipped = current != null ? current.func_77973_b() : null;
        if (player.func_70093_af() && equipped instanceof IToolWrench && ((IToolWrench) equipped).canWrench(player, pos)) {
            ((TileRefinery) tile).resetFilters();
            ((IToolWrench) equipped).wrenchUsed(player, pos);
            return true;
        }

        if (current != null) {
            if (!world.field_72995_K) {
                if (FluidContainerRegistry.isEmptyContainer(current)) {
                    if (TankUtils.handleRightClick((TileRefinery) tile, side, player, false, true)) {
                        return true;
                    }
                } else if (FluidContainerRegistry.isFilledContainer(current)) {
                    if (TankUtils.handleRightClick((TileRefinery) tile, side, player, true, false)) {
                        return true;
                    }
                }
            } else if (FluidContainerRegistry.isContainer(current)) {
                return true;
            }
        }

        if (!world.field_72995_K) {
            player.openGui(BuildCraftFactory.instance, GuiIds.REFINERY, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        return true;
    }

    @Override
    public int func_149645_b() {
        return 2;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }
}
