/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.api.transport.ICustomPipeConnection;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.block.TileBuildCraft;

public class BlockTank extends BlockBuildCraft implements ICustomPipeConnection {
    private static final boolean DEBUG_MODE = false;

    public BlockTank() {
        super(Material.field_151592_s, JOINED_BELOW);
        func_149711_c(0.5F);
        func_149647_a(BCCreativeTab.get("main"));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileBuildCraft) {
            TileTank tank = (TileTank) tile;
            tank.onBlockBreak();
        }

        TileEntity tileAbove = world.func_175625_s(pos.func_177984_a());
        TileEntity tileBelow = world.func_175625_s(pos.func_177977_b());

        super.func_180663_b(world, pos, state);

        if (tileAbove instanceof TileBuildCraft) {
            ((TileTank) tileAbove).updateComparators();
            world.func_175656_a(pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()).func_177226_a(JOINED_BELOW, false));
        }

        if (tileBelow instanceof TileBuildCraft) {
            ((TileTank) tileBelow).updateComparators();
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);

        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        IBlockState stateBelow = world.func_180495_p(pos.func_177977_b());

        if (stateAbove.func_177230_c() == this) {
            world.func_175656_a(pos.func_177984_a(), stateAbove.func_177226_a(JOINED_BELOW, true));
        }

        if (stateBelow.func_177230_c() == this) {
            world.func_175656_a(pos, state.func_177226_a(JOINED_BELOW, true));
        }
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileTank();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing side, float par7, float par8,
            float par9) {
        if (super.func_180639_a(world, pos, state, entityplayer, side, par7, par8, par9)) {
            return true;
        }

        ItemStack current = entityplayer.field_71071_by.func_70448_g();

        if (current != null) {
            TileEntity tile = world.func_175625_s(pos);

            if (tile instanceof TileBuildCraft) {
                TileTank tank = (TileTank) tile;

                if (FluidUtil.interactWithTank(current, entityplayer, tank, side)) {
                    return true;
                }
                return false;

//                // Handle FluidContainerRegistry
//                if (FluidContainerRegistry.isContainer(current)) {
//                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem(current);
//                    // Handle filled containers
//                    if (liquid != null) {
//                        int qty = tank.fill(null, liquid, true);
//
//                        if (qty != 0 && !BuildCraftCore.debugWorldgen && !entityplayer.capabilities.isCreativeMode) {
//                            if (current.stackSize > 1) {
//                                if (!entityplayer.inventory.addItemStackToInventory(FluidContainerRegistry.drainFluidContainer(current))) {
//                                    entityplayer.dropPlayerItemWithRandomChoice(FluidContainerRegistry.drainFluidContainer(current), false);
//                                }
//
//                                entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, InvUtils.consumeItem(current));
//                            } else {
//                                entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, FluidContainerRegistry
//                                        .drainFluidContainer(current));
//                            }
//                        }
//
//                        return true;
//
//                        // Handle empty containers
//                    } else {
//                        FluidStack available = tank.getTankInfo(null)[0].fluid;
//
//                        if (available != null) {
//                            ItemStack filled = FluidContainerRegistry.fillFluidContainer(available, current);
//
//                            liquid = FluidContainerRegistry.getFluidForFilledItem(filled);
//
//                            if (liquid != null) {
//                                if (!BuildCraftCore.debugWorldgen && !entityplayer.capabilities.isCreativeMode) {
//                                    if (current.stackSize > 1) {
//                                        if (!entityplayer.inventory.addItemStackToInventory(filled)) {
//                                            return false;
//                                        } else {
//                                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, InvUtils.consumeItem(
//                                                    current));
//                                        }
//                                    } else {
//                                        entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, InvUtils.consumeItem(
//                                                current));
//                                        entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, filled);
//                                    }
//                                }
//
//                                tank.drain(null, liquid.amount, true);
//
//                                return true;
//                            }
//                        }
//                    }
//                } else if (current.getItem() instanceof IFluidContainerItem) {
//                    if (current.stackSize != 1) {
//                        return false;
//                    }
//
//                    if (!world.isRemote) {
//                        IFluidContainerItem container = (IFluidContainerItem) current.getItem();
//                        FluidStack liquid = container.getFluid(current);
//                        FluidStack tankLiquid = tank.getTankInfo(null)[0].fluid;
//                        boolean mustDrain = liquid == null || liquid.amount == 0;
//                        boolean mustFill = tankLiquid == null || tankLiquid.amount == 0;
//                        if (mustDrain && mustFill) {
//                            // Both are empty, do nothing
//                        } else if (mustDrain || !entityplayer.isSneaking()) {
//                            liquid = tank.drain(null, 1000, false);
//                            int qtyToFill = container.fill(current, liquid, true);
//                            tank.drain(null, qtyToFill, true);
//                        } else if (mustFill || entityplayer.isSneaking()) {
//                            if (liquid != null && liquid.amount > 0) {
//                                int qty = tank.fill(null, liquid, false);
//                                tank.fill(null, container.drain(current, qty, true), true);
//                            }
//                        }
//                    }
//
//                    return true;
//                }
            }
        } else if (DEBUG_MODE) {
            TileEntity tile = world.func_175625_s(pos);

            if (tile instanceof TileBuildCraft) {
                TileTank tank = (TileTank) tile;
                if (tank.getTankInfo(null)[0].fluid != null) {
                    entityplayer.func_146105_b(new ChatComponentText("Amount: " + tank.getTankInfo(null)[0].fluid.amount + " mB"));
                }
            }
        }

        return false;
    }

    @Override
    public boolean func_176225_a(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return world.func_180495_p(pos).func_177230_c() != this;
        } else {
            return super.func_176225_a(world, pos, side);
        }
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);

        if (tile instanceof TileBuildCraft) {
            TileTank tank = (TileTank) tile;
            return tank.getFluidLightLevel();
        }

        return super.getLightValue(world, pos);
    }

    @Override
    public boolean func_149740_M() {
        return true;
    }

    @Override
    public int func_180641_l(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);

        if (tile instanceof TileBuildCraft) {
            TileTank tank = (TileTank) tile;
            return tank.getComparatorInputOverride();
        }

        return 0;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    public AxisAlignedBB getBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB(2 / 16f, 0F, 2 / 16f, 14 / 16f, 1F, 14 / 16f);
    }

    @Override
    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        return face.func_176740_k() != Axis.Y ? 2 / 16f : 0;
    }
}
