/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.gui.ContainerDummy;
import buildcraft.core.lib.inventory.*;
import buildcraft.core.lib.utils.CraftingUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.*;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;

import java.lang.ref.WeakReference;

public class TileAutoWorkbench extends TileBuildCraft implements ISidedInventory, IHasWork, IRedstoneEngineReceiver {
    public static final int SLOT_RESULT = 9;
    public static final int CRAFT_TIME = 256;
    public static final int UPDATE_TIME = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 10);

    public int progress = 0;
    public LocalInventoryCrafting craftMatrix = new LocalInventoryCrafting();

    private SimpleInventory resultInv = new SimpleInventory(1, "Auto Workbench", 64);
    private SimpleInventory inputInv = new SimpleInventory(9, "Auto Workbench", 64);

    private IInventory inv = InventoryConcatenator.make().add(inputInv).add(resultInv).add(craftMatrix);

    private SlotCrafting craftSlot;
    private InventoryCraftResult craftResult = new InventoryCraftResult();

    private int[] bindings = new int[9];
    private int[] bindingCounts = new int[9];

    private int update = Utils.RANDOM.nextInt();

    private boolean hasWork = false;
    private boolean scheduledCacheRebuild = false;

    public TileAutoWorkbench() {
        super();
        this.setBattery(new RFBattery(16, 16, 0));
    }

    @Override
    public boolean hasWork() {
        return hasWork;
    }

    @Override
    public boolean canConnectRedstoneEngine(EnumFacing side) {
        return true;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing side) {
        TileEntity tile = field_145850_b.func_175625_s(field_174879_c.func_177972_a(side));
        return tile instanceof IRedstoneEngine;
    }

    public class LocalInventoryCrafting extends InventoryCrafting {
        public IRecipe currentRecipe;
        public boolean useBindings, isJammed;

        public LocalInventoryCrafting() {
            super(new ContainerDummy(), 3, 3);
        }

        @Override
        public ItemStack func_70301_a(int slot) {
            if (useBindings) {
                if (slot >= 0 && slot < 9 && bindings[slot] >= 0) {
                    return inputInv.func_70301_a(bindings[slot]);
                } else {
                    return null;
                }
            } else {
				return super.func_70301_a(slot);
			}
        }

        public ItemStack getRecipeOutput() {
			currentRecipe = findRecipe(); // Fixes repair recipe handling (why is it not dynamic?)
            if (currentRecipe == null) {
                return null;
            }
            ItemStack result = currentRecipe.func_77572_b(this);
            if (result != null) {
                result = result.func_77946_l();
            }
            return result;
        }

        private IRecipe findRecipe() {
            for (IInvSlot slot : InventoryIterator.getIterable(this, EnumFacing.UP)) {
                ItemStack stack = slot.getStackInSlot();
                if (stack == null) {
                    continue;
                }
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    return null;
                }
            }

            return CraftingUtils.findMatchingRecipe(craftMatrix, field_145850_b);
        }

        public void rebuildCache() {
            currentRecipe = findRecipe();

            if (currentRecipe == null) {
                hasWork = false;
                return;
            }

            ItemStack result = currentRecipe.func_77572_b(craftMatrix);
            hasWork = result != null;
            ItemStack resultInto = resultInv.func_70301_a(0);

            if (resultInto != null && (!StackHelper.canStacksMerge(resultInto, result) || resultInto.field_77994_a + result.field_77994_a > resultInto
                    .func_77976_d())) {
                isJammed = true;
            } else {
                isJammed = false;
            }
        }

        @Override
        public void func_70299_a(int slot, ItemStack stack) {
            if (useBindings) {
                if (slot >= 0 && slot < 9 && bindings[slot] >= 0) {
                    inputInv.func_70299_a(bindings[slot], stack);
                }
                return;
            }
            super.func_70299_a(slot, stack);
            scheduledCacheRebuild = true;
        }

        @Override
        public void func_70296_d() {
            super.func_70296_d();
            scheduledCacheRebuild = true;
        }

        @Override
        public ItemStack func_70298_a(int slot, int amount) {
            if (useBindings) {
                if (slot >= 0 && slot < 9 && bindings[slot] >= 0) {
                    return inputInv.func_70298_a(bindings[slot], amount);
                } else {
                    return null;
                }
            }
            scheduledCacheRebuild = true;
            return func_70298_a(slot, amount);
        }

        public void setUseBindings(boolean use) {
            useBindings = use;
        }
    }

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer) field_145850_b, field_174879_c.func_177984_a());
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        inv.func_70296_d();
    }

    @Override
    public int func_70302_i_() {
        return 10;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return inv.func_70301_a(slot);
    }

    @Override
    public ItemStack func_70298_a(int slot, int count) {
        return inv.func_70298_a(slot, count);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        inv.func_70299_a(slot, stack);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return inv.func_70304_b(slot);
    }

    @Override
    public String getInventoryName() {
        return "";
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return field_145850_b.func_175625_s(field_174879_c) == this && player.func_174818_b(field_174879_c) <= 64.0D;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        resultInv.readFromNBT(data);
        if (data.func_74764_b("input")) {
            InvUtils.readInvFromNBT(inputInv, "input", data);
            InvUtils.readInvFromNBT(craftMatrix, "matrix", data);
        } else {
            InvUtils.readInvFromNBT(inputInv, "matrix", data);
            for (int i = 0; i < 9; i++) {
                ItemStack inputStack = inputInv.func_70301_a(i);
                if (inputStack != null) {
                    ItemStack matrixStack = inputStack.func_77946_l();
                    matrixStack.field_77994_a = 1;
                    craftMatrix.func_70299_a(i, matrixStack);
                }
            }
        }

        craftMatrix.rebuildCache();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        resultInv.writeToNBT(data);
        InvUtils.writeInvToNBT(inputInv, "input", data);
        InvUtils.writeInvToNBT(craftMatrix, "matrix", data);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();

        if (field_145850_b.field_72995_K) {
            return;
        }

        if (scheduledCacheRebuild) {
            craftMatrix.rebuildCache();
            scheduledCacheRebuild = false;
        }

        if (craftMatrix.isJammed || craftMatrix.currentRecipe == null) {
            progress = 0;
            return;
        }

        if (craftSlot == null) {
            craftSlot = new SlotCrafting(getInternalPlayer().get(), craftMatrix, craftResult, 0, 0, 0);
        }

        if (!hasWork) {
            return;
        }

        int updateNext = update + getBattery().getEnergyStored() + 1;
        int updateThreshold = (update & ~15) + 16;
        update = Math.min(updateThreshold, updateNext);
        if ((update % UPDATE_TIME) == 0) {
            updateCrafting();
        }
        getBattery().setEnergy(0);
    }

    public int getProgressScaled(int i) {
        return (progress * i) / CRAFT_TIME;
    }

    /** Increment craft job, find recipes, produce output */
    private void updateCrafting() {
        progress += UPDATE_TIME;

        for (int i = 0; i < 9; i++) {
            bindingCounts[i] = 0;
        }
        for (int i = 0; i < 9; i++) {
            ItemStack comparedStack = craftMatrix.func_70301_a(i);
            if (comparedStack == null || comparedStack.func_77973_b() == null) {
                bindings[i] = -1;
                continue;
            }

            if (bindings[i] == -1 || !StackHelper.isMatchingItem(inputInv.func_70301_a(bindings[i]), comparedStack, true, true)) {
                boolean found = false;
                for (int j = 0; j < 9; j++) {
                    if (j == bindings[i]) {
                        continue;
                    }

                    ItemStack inputInvStack = inputInv.func_70301_a(j);

                    if (StackHelper.isMatchingItem(inputInvStack, comparedStack, true, false) && inputInvStack.field_77994_a > bindingCounts[j]) {
                        found = true;
                        bindings[i] = j;
                        bindingCounts[j]++;
                        break;
                    }
                }
                if (!found) {
                    craftMatrix.isJammed = true;
                    progress = 0;
                    return;
                }
            } else {
                bindingCounts[bindings[i]]++;
            }
        }

        for (int i = 0; i < 9; i++) {
            if (bindingCounts[i] > 0) {
                ItemStack stack = inputInv.func_70301_a(i);
                if (stack != null && stack.field_77994_a < bindingCounts[i]) {
                    // Do not break progress yet, instead give it a chance to rebuild
                    // It will quit when trying to find a valid binding to "fit in"
                    for (int j = 0; j < 9; j++) {
                        if (bindings[j] == i) {
                            bindings[j] = -1;
                        }
                    }
                    return;
                }
            }
        }

        if (progress < CRAFT_TIME) {
            return;
        }

        progress = 0;

        craftMatrix.setUseBindings(true);
        ItemStack result = craftMatrix.getRecipeOutput();

        if (result != null && result.field_77994_a > 0) {
            ItemStack resultInto = resultInv.func_70301_a(0);

            craftSlot.func_82870_a(getInternalPlayer().get(), result);

            if (resultInto == null) {
                resultInv.func_70299_a(0, result);
            } else {
                resultInto.field_77994_a += result.field_77994_a;
            }
        }

        craftMatrix.setUseBindings(false);
        craftMatrix.rebuildCache();
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == SLOT_RESULT) {
            return false;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return false;
        }
        return true;
    }

    @Override
    public int[] func_180463_a(EnumFacing face) {
        return SLOTS;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (slot >= 9) {
            return false;
        }
        ItemStack slotStack = inv.func_70301_a(slot);
        if (StackHelper.canStacksMerge(stack, slotStack)) {
            return true;
        }
        for (int i = 0; i < 9; i++) {
            ItemStack inputStack = craftMatrix.func_70301_a(i);
            if (inputStack != null && StackHelper.isMatchingItem(inputStack, stack, true, false)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == SLOT_RESULT;
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }
}
