/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 *
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;

import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.Transactor;

import net.minecraft.util.EnumFacing.Axis;
public class TileChute extends TileBuildCraft implements IInventory, IRedstoneEngineReceiver {

    private final SimpleInventory inventory = new SimpleInventory(4, "Chute", 64);
    private boolean isEmpty;

    @Override
    public void initialize() {
        this.setBattery(new RFBattery(10, 10, 0));
        inventory.addListener(this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);

        NBTTagCompound p = nbtTagCompound;

        if (nbtTagCompound.func_74764_b("inventory")) {
            // to support pre 6.0 loading
            p = nbtTagCompound.func_74775_l("inventory");
        }

        inventory.readFromNBT(p);
        inventory.func_70296_d();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);

        inventory.writeToNBT(nbtTagCompound);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (field_145850_b.field_72995_K || isEmpty || field_145850_b.func_82737_E() % 2 != 0) {
            return;
        }

        TileEntity outputTile = getTile(EnumFacing.DOWN);

        ITransactor transactor = Transactor.getTransactorFor(outputTile, EnumFacing.UP);

        if (transactor == null) {
            if (outputTile instanceof IInjectable && getBattery().getEnergyStored() >= 10) {
                ItemStack stackToOutput = null;
                int internalSlot = 0;

                getBattery().useEnergy(10, 10, false);

                for (; internalSlot < inventory.func_70302_i_(); internalSlot++) {
                    ItemStack stackInSlot = inventory.func_70301_a(internalSlot);
                    if (stackInSlot == null || stackInSlot.field_77994_a == 0) {
                        continue;
                    }
                    stackToOutput = stackInSlot.func_77946_l();
                    stackToOutput.field_77994_a = 1;
                    break;
                }

                if (stackToOutput != null) {
                    int used = ((IInjectable) outputTile).injectItem(stackToOutput, true, EnumFacing.UP, null);
                    if (used > 0) {
                        func_70298_a(internalSlot, 1);
                    }
                }
            }

            return;
        }

        for (int internalSlot = 0; internalSlot < inventory.func_70302_i_(); internalSlot++) {
            ItemStack stackInSlot = inventory.func_70301_a(internalSlot);
            if (stackInSlot == null || stackInSlot.field_77994_a == 0) {
                continue;
            }

            ItemStack clonedStack = stackInSlot.func_77946_l().func_77979_a(1);
            if (transactor.add(clonedStack, true).field_77994_a > 0) {
                inventory.func_70298_a(internalSlot, 1);
                return;
            }
        }
    }

    @Override
    public void func_70296_d() {
        isEmpty = true;

        for (int internalSlot = 0; internalSlot < inventory.func_70302_i_(); internalSlot++) {
            ItemStack stackInSlot = inventory.func_70301_a(internalSlot);
            if (stackInSlot != null && stackInSlot.field_77994_a > 0) {
                isEmpty = false;
                return;
            }
        }
    }

    /** IInventory Implementation * */
    @Override
    public int func_70302_i_() {
        return inventory.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int slotId) {
        return inventory.func_70301_a(slotId);
    }

    @Override
    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack output = inventory.func_70298_a(slotId, count);
        return output;
    }

    @Override
    public ItemStack func_70304_b(int slotId) {
        return inventory.func_70304_b(slotId);
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        inventory.func_70299_a(slotId, itemStack);
    }

    @Override
    public String getInventoryName() {
        return inventory.func_70005_c_();
    }

    @Override
    public int func_70297_j_() {
        return inventory.func_70297_j_();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return field_145850_b.func_175625_s(field_174879_c) == this && entityPlayer.func_174818_b(field_174879_c) <= 64.0D;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }

    @Override
    public boolean canConnectRedstoneEngine(EnumFacing side) {
        return side.func_176740_k() != Axis.Y;
    }

    @Override
    public String getOwner() {
        return super.getOwner();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing side) {
        return canConnectRedstoneEngine(side) && !(getTile(side) instanceof IPipeTile);
    }
}
