package buildcraft.factory.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.World;

import buildcraft.BuildCraftFactory;
import buildcraft.api.transport.ICustomPipeConnection;
import buildcraft.core.GuiIds;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.factory.tile.TileEnergyHeater;

import net.minecraft.util.EnumFacing.Axis;
public class BlockEnergyHeater extends BlockBuildCraft implements ICustomPipeConnection {
    public BlockEnergyHeater() {
        super(Material.field_151573_f, FACING_PROP);
        func_149713_g(0);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEnergyHeater();
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing current = state.func_177229_b(FACING_PROP);
        current = current.func_176732_a(Axis.Y);
        world.func_175656_a(pos, state.func_177226_a(FACING_PROP, current));
        return true;
    }

    @Override
    public boolean func_149730_j() {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY,
            float hitZ) {
        if (super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ)) {
            return true;
        }

        TileEntity tile = world.func_175625_s(pos);

        if (!(tile instanceof TileEnergyHeater)) {
            return false;
        }

        if (!world.field_72995_K) {
            player.openGui(BuildCraftFactory.instance, GuiIds.ENERGY_HEATER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        return true;
    }

    @Override
    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        EnumFacing current = state.func_177229_b(FACING_PROP);
        if (current.func_176746_e().func_176740_k() == face.func_176740_k()) return 0;
        return 0.25f;
    }
}
