/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.slots.SlotOutput;
import buildcraft.core.lib.gui.slots.SlotUntouchable;
import buildcraft.factory.TileAutoWorkbench;

public class ContainerAutoWorkbench extends BuildCraftContainer {

    public IInventory craftResult;

    private final TileAutoWorkbench tile;
    private int lastProgress;
    private ItemStack prevOutput;

    public ContainerAutoWorkbench(EntityPlayer player, TileAutoWorkbench t) {
        super(player, t.func_70302_i_());

        craftResult = new InventoryCraftResult();
        this.tile = t;
        func_75146_a(new SlotUntouchable(craftResult, 0, 93, 27));
        func_75146_a(new SlotOutput(tile, TileAutoWorkbench.SLOT_RESULT, 124, 35));
        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 3; x++) {
                func_75146_a(new SlotWorkbench(tile, 10 + x + y * 3, 30 + x * 18, 17 + y * 18));
            }
        }

        for (int x = 0; x < 9; x++) {
            func_75146_a(new Slot(tile, x, 8 + x * 18, 84));
        }

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 9; x++) {
                func_75146_a(new Slot(player.field_71071_by, x + y * 9 + 9, 8 + x * 18, 115 + y * 18));
            }
        }

        for (int x = 0; x < 9; x++) {
            func_75146_a(new Slot(player.field_71071_by, x, 8 + x * 18, 173));
        }

        func_75130_a(tile);
    }

    @Override
    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        icrafting.func_71112_a(this, 0, tile.progress);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (Object crafter : field_75149_d) {
            ICrafting icrafting = (ICrafting) crafter;

            if (lastProgress != tile.progress) {
                icrafting.func_71112_a(this, 0, tile.progress);
            }
        }

        ItemStack output = craftResult.func_70301_a(0);
        if (output != prevOutput) {
            prevOutput = output;
            func_75130_a(tile.craftMatrix);
        }

        lastProgress = tile.progress;
    }

    @Override
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0:
                tile.progress = data;
                break;
        }
    }

    @Override
    public final void func_75130_a(IInventory inv) {
        super.func_75130_a(inv);
        tile.craftMatrix.rebuildCache();
        ItemStack output = tile.craftMatrix.getRecipeOutput();
        craftResult.func_70299_a(0, output);
    }

    @Override
    public ItemStack func_75144_a(int i, int j, int modifier, EntityPlayer entityplayer) {
        ItemStack stack = super.func_75144_a(i, j, modifier, entityplayer);
        func_75130_a(tile.craftMatrix);
        return stack;
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return tile.func_70300_a(entityplayer);
    }
}
